/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.util.List;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.clustering.EJBBoundClusteringMetaData;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentDescription;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentDescription;
import org.jboss.as.ejb3.component.session.ClusteringInfo;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.component.singleton.SingletonComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.ejb3.annotation.Clustered;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;

public class ClusteredMergingProcessor
extends AbstractMergingProcessor<EJBComponentDescription> {
    public ClusteredMergingProcessor() {
        super(EJBComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription ejbComponentDescription) throws DeploymentUnitProcessingException {
        EEModuleClassDescription clazz = applicationClasses.getClassByName(componentClass.getName());
        if (clazz == null) {
            return;
        }
        ClassAnnotationInformation clustering = clazz.getAnnotationInformation(Clustered.class);
        if (clustering == null || clustering.getClassLevelAnnotations().isEmpty()) {
            return;
        }
        ClusteringInfo clusteringInfo = (ClusteringInfo)clustering.getClassLevelAnnotations().get(0);
        this.validateAndMarkBeanAsClustered(ejbComponentDescription, clusteringInfo, deploymentUnit);
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription ejbComponentDescription) throws DeploymentUnitProcessingException {
        List clusteringMetaDatas;
        AssemblyDescriptorMetaData assemblyMetadata;
        EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        Boolean beanClustered = null;
        Boolean allBeansClustered = null;
        if (ejbJarMetaData != null && (assemblyMetadata = ejbJarMetaData.getAssemblyDescriptor()) != null && (clusteringMetaDatas = assemblyMetadata.getAny(EJBBoundClusteringMetaData.class)) != null) {
            for (EJBBoundClusteringMetaData clusteringMetaData : clusteringMetaDatas) {
                if ("*".equals(clusteringMetaData.getEjbName())) {
                    allBeansClustered = clusteringMetaData.isClustered();
                    continue;
                }
                if (!ejbComponentDescription.getComponentName().equals(clusteringMetaData.getEjbName())) continue;
                beanClustered = clusteringMetaData.isClustered();
            }
        }
        if (beanClustered != null) {
            if (beanClustered.booleanValue()) {
                this.validateAndMarkBeanAsClustered(ejbComponentDescription, new ClusteringInfo(), deploymentUnit);
            } else {
                this.validateAndMarkBeanAsClustered(ejbComponentDescription, null, deploymentUnit);
            }
        } else if (allBeansClustered != null) {
            if (allBeansClustered.booleanValue()) {
                this.validateAndMarkBeanAsClustered(ejbComponentDescription, new ClusteringInfo(), deploymentUnit);
            } else {
                this.validateAndMarkBeanAsClustered(ejbComponentDescription, null, deploymentUnit);
            }
        }
    }

    private void validateAndMarkBeanAsClustered(EJBComponentDescription ejbComponentDescription, ClusteringInfo clusteringInfo, DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        if (ejbComponentDescription instanceof MessageDrivenComponentDescription) {
            throw EjbMessages.MESSAGES.clusteredAnnotationIsNotApplicableForMDB(deploymentUnit, ejbComponentDescription.getComponentName(), ejbComponentDescription.getComponentClassName());
        }
        if (ejbComponentDescription instanceof EntityBeanComponentDescription) {
            throw EjbMessages.MESSAGES.clusteredAnnotationIsNotApplicableForEntityBean(deploymentUnit, ejbComponentDescription.getComponentName(), ejbComponentDescription.getComponentClassName());
        }
        if (ejbComponentDescription instanceof SingletonComponentDescription) {
            throw EjbMessages.MESSAGES.clusteredAnnotationNotYetImplementedForSingletonBean(deploymentUnit, ejbComponentDescription.getComponentName(), ejbComponentDescription.getComponentClassName());
        }
        if (!(ejbComponentDescription instanceof SessionBeanComponentDescription)) {
            throw EjbMessages.MESSAGES.clusteredAnnotationIsNotApplicableForBean(deploymentUnit, ejbComponentDescription.getComponentName(), ejbComponentDescription.getComponentClassName());
        }
        ((SessionBeanComponentDescription)ejbComponentDescription).setClustering(clusteringInfo);
    }
}

