/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.lang.reflect.Constructor;
import java.sql.Driver;
import java.util.ServiceLoader;
import org.jboss.as.connector.ConnectorLogger;
import org.jboss.as.connector.ConnectorMessages;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.JdbcDriverAdd;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class JdbcDriverRemove
extends AbstractRemoveStepHandler {
    static final JdbcDriverRemove INSTANCE = new JdbcDriverRemove();

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String driverName = model.get(Constants.DRIVER_NAME.getName()).asString();
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceName jdbcServiceName = ServiceName.JBOSS.append(new String[]{"jdbc-driver", driverName.replaceAll("\\.", "_")});
        ServiceController jdbcServiceController = registry.getService(jdbcServiceName);
        context.removeService(jdbcServiceController);
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) {
        block6: {
            Module module;
            ModuleIdentifier moduleId;
            ServiceTarget target;
            String xaDataSourceClassName;
            String dataSourceClassName;
            String driverClassName;
            Integer minorVersion;
            Integer majorVersion;
            String driverName;
            block5: {
                driverName = model.require(Constants.DRIVER_NAME.getName()).asString();
                String moduleName = model.require(Constants.DRIVER_MODULE_NAME.getName()).asString();
                majorVersion = model.hasDefined(Constants.DRIVER_MAJOR_VERSION.getName()) ? Integer.valueOf(model.get(Constants.DRIVER_MAJOR_VERSION.getName()).asInt()) : null;
                minorVersion = model.hasDefined(Constants.DRIVER_MINOR_VERSION.getName()) ? Integer.valueOf(model.get(Constants.DRIVER_MINOR_VERSION.getName()).asInt()) : null;
                driverClassName = model.hasDefined(Constants.DRIVER_CLASS_NAME.getName()) ? model.get(Constants.DRIVER_CLASS_NAME.getName()).asString() : null;
                dataSourceClassName = model.hasDefined(Constants.DRIVER_DATASOURCE_CLASS_NAME.getName()) ? model.get(Constants.DRIVER_DATASOURCE_CLASS_NAME.getName()).asString() : null;
                xaDataSourceClassName = model.hasDefined(Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.getName()) ? model.get(Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.getName()).asString() : null;
                target = context.getServiceTarget();
                try {
                    moduleId = ModuleIdentifier.create((String)moduleName);
                    module = Module.getCallerModuleLoader().loadModule(moduleId);
                }
                catch (ModuleLoadException e) {
                    context.getFailureDescription().set(ConnectorMessages.MESSAGES.failedToLoadModuleDriver(moduleName));
                    return;
                }
                if (driverClassName != null) break block5;
                ServiceLoader serviceLoader = module.loadService(Driver.class);
                if (serviceLoader == null) break block6;
                for (Driver driver : serviceLoader) {
                    JdbcDriverAdd.startDriverServices(target, moduleId, driver, driverName, majorVersion, minorVersion, dataSourceClassName, xaDataSourceClassName);
                }
                break block6;
            }
            try {
                Class<Driver> driverClass = module.getClassLoader().loadClass(driverClassName).asSubclass(Driver.class);
                Constructor<Driver> constructor = driverClass.getConstructor(new Class[0]);
                Driver driver = constructor.newInstance(new Object[0]);
                JdbcDriverAdd.startDriverServices(target, moduleId, driver, driverName, majorVersion, minorVersion, dataSourceClassName, xaDataSourceClassName);
            }
            catch (Exception e) {
                ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.cannotInstantiateDriverClass(driverClassName, e);
            }
        }
    }
}

