/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.processors;

import java.io.Closeable;
import java.io.InputStream;
import org.jboss.as.connector.ConnectorMessages;
import org.jboss.as.connector.metadata.xmldescriptors.IronJacamarXmlDescriptor;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.metadata.ironjacamar.IronJacamarParser;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class IronJacamarDeploymentParsingProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        block9: {
            ResourceRoot resourceRoot = (ResourceRoot)phaseContext.getDeploymentUnit().getAttachment(Attachments.DEPLOYMENT_ROOT);
            VirtualFile deploymentRoot = resourceRoot.getRoot();
            if (deploymentRoot == null || !deploymentRoot.exists()) {
                return;
            }
            String deploymentRootName = deploymentRoot.getName().toLowerCase();
            VirtualFile serviceXmlFile = null;
            if (deploymentRootName.endsWith(".rar")) {
                serviceXmlFile = deploymentRoot.getChild("/META-INF/ironjacamar.xml");
            }
            if (serviceXmlFile == null || !serviceXmlFile.exists()) {
                return;
            }
            InputStream xmlStream = null;
            IronJacamar result = null;
            try {
                xmlStream = serviceXmlFile.openStream();
                result = new IronJacamarParser().parse(xmlStream);
                if (result != null) {
                    IronJacamarXmlDescriptor xmlDescriptor = new IronJacamarXmlDescriptor(result);
                    phaseContext.getDeploymentUnit().putAttachment(IronJacamarXmlDescriptor.ATTACHMENT_KEY, (Object)xmlDescriptor);
                    break block9;
                }
                throw ConnectorMessages.MESSAGES.failedToParseServiceXml(serviceXmlFile);
            }
            catch (Exception e) {
                throw ConnectorMessages.MESSAGES.failedToParseServiceXml(e, serviceXmlFile);
            }
            finally {
                VFSUtils.safeClose((Closeable)xmlStream);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

