/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.processors;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.metadata.ds.DsParser;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class DsXmlDeploymentParsingProcessor
implements DeploymentUnitProcessor {
    static final AttachmentKey<AttachmentList<DataSources>> DATA_SOURCES_ATTACHMENT_KEY = AttachmentKey.createList(DataSources.class);
    private static final String[] LOCATIONS = new String[]{"WEB-INF", "META-INF"};

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Set<VirtualFile> files = this.dataSources(deploymentUnit);
        for (VirtualFile f : files) {
            FileInputStream xmlStream;
            block5: {
                xmlStream = null;
                try {
                    xmlStream = new FileInputStream(f.getPhysicalFile());
                    DsParser parser = new DsParser();
                    DataSources dataSources = parser.parse((InputStream)xmlStream);
                    if (dataSources == null) break block5;
                    deploymentUnit.addToAttachmentList(DATA_SOURCES_ATTACHMENT_KEY, (Object)dataSources);
                }
                catch (Exception e) {
                    try {
                        throw new DeploymentUnitProcessingException(e.getMessage(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        VFSUtils.safeClose(xmlStream);
                        throw throwable;
                    }
                }
            }
            VFSUtils.safeClose((Closeable)xmlStream);
        }
    }

    private Set<VirtualFile> dataSources(DeploymentUnit deploymentUnit) {
        VirtualFile deploymentRoot = ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        if (deploymentRoot == null || !deploymentRoot.exists()) {
            return Collections.emptySet();
        }
        String deploymentRootName = deploymentRoot.getName().toLowerCase();
        if (deploymentRootName.endsWith("-ds.xml")) {
            return Collections.singleton(deploymentRoot);
        }
        HashSet<VirtualFile> ret = new HashSet<VirtualFile>();
        for (String location : LOCATIONS) {
            VirtualFile loc = deploymentRoot.getChild(location);
            if (!loc.exists()) continue;
            for (VirtualFile file : loc.getChildren()) {
                if (!file.getName().endsWith("-ds.xml")) continue;
                ret.add(file);
            }
        }
        return ret;
    }

    public void undeploy(DeploymentUnit context) {
    }
}

