/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper.relation.lazy.initializor;

import java.util.List;
import java.util.Map;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.entities.mapper.relation.lazy.initializor.AbstractCollectionInitializor;
import org.hibernate.envers.entities.mapper.relation.query.RelationQueryGenerator;
import org.hibernate.envers.reader.AuditReaderImplementor;

public class ArrayCollectionInitializor
extends AbstractCollectionInitializor<Object[]> {
    private final MiddleComponentData elementComponentData;
    private final MiddleComponentData indexComponentData;

    public ArrayCollectionInitializor(AuditConfiguration verCfg, AuditReaderImplementor versionsReader, RelationQueryGenerator queryGenerator, Object primaryKey, Number revision, MiddleComponentData elementComponentData, MiddleComponentData indexComponentData) {
        super(verCfg, versionsReader, queryGenerator, primaryKey, revision);
        this.elementComponentData = elementComponentData;
        this.indexComponentData = indexComponentData;
    }

    @Override
    protected Object[] initializeCollection(int size) {
        return new Object[size];
    }

    @Override
    protected void addToCollection(Object[] collection, Object collectionRow) {
        Object elementData = ((List)collectionRow).get(this.elementComponentData.getComponentIndex());
        Object element = this.elementComponentData.getComponentMapper().mapToObjectFromFullMap(this.entityInstantiator, (Map)elementData, null, this.revision);
        Object indexData = ((List)collectionRow).get(this.indexComponentData.getComponentIndex());
        Object indexObj = this.indexComponentData.getComponentMapper().mapToObjectFromFullMap(this.entityInstantiator, (Map)indexData, element, this.revision);
        int index = ((Number)indexObj).intValue();
        collection[index] = element;
    }
}

