/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.api.metadata.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.common.api.metadata.JCAMetadata;
import org.jboss.jca.common.api.metadata.ValidatableMetadata;
import org.jboss.jca.common.api.validator.ValidateException;

public final class Extension
implements JCAMetadata,
ValidatableMetadata {
    private static final long serialVersionUID = -6275984008991105644L;
    private final String className;
    private final Map<String, String> configPropertiesMap;

    public Extension(String className, Map<String, String> configPropertiesMap) throws ValidateException {
        this.className = className;
        if (configPropertiesMap != null) {
            this.configPropertiesMap = new HashMap<String, String>(configPropertiesMap.size());
            this.configPropertiesMap.putAll(configPropertiesMap);
        } else {
            this.configPropertiesMap = Collections.emptyMap();
        }
        this.validate();
    }

    public final String getClassName() {
        return this.className;
    }

    public final Map<String, String> getConfigPropertiesMap() {
        return Collections.unmodifiableMap(this.configPropertiesMap);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.configPropertiesMap == null ? 0 : ((Object)this.configPropertiesMap).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Extension)) {
            return false;
        }
        Extension other = (Extension)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        return !(this.configPropertiesMap == null ? other.configPropertiesMap != null : !((Object)this.configPropertiesMap).equals(other.configPropertiesMap));
    }

    @Override
    public void validate() throws ValidateException {
        if (this.className == null || this.className.trim().length() == 0) {
            throw new ValidateException("className (xml attribute " + (Object)((Object)Attribute.CLASS_NAME) + ") is required in " + this.getClass().getCanonicalName());
        }
    }

    public static enum Attribute {
        CLASS_NAME("class-name");

        private final String name;

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Tag {
        UNKNOWN(null),
        CONFIG_PROPERTY("config-property");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

