/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.felix;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Permission;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.framework.capabilityset.Attribute;
import org.apache.felix.framework.capabilityset.Capability;
import org.apache.felix.framework.capabilityset.Directive;
import org.apache.felix.framework.capabilityset.Requirement;
import org.apache.felix.framework.resolver.Content;
import org.apache.felix.framework.resolver.FragmentRequirement;
import org.apache.felix.framework.resolver.Module;
import org.apache.felix.framework.resolver.Wire;
import org.apache.felix.framework.util.VersionRange;
import org.apache.felix.framework.util.manifestparser.CapabilityImpl;
import org.apache.felix.framework.util.manifestparser.R4Library;
import org.apache.felix.framework.util.manifestparser.RequirementImpl;
import org.jboss.logging.Logger;
import org.jboss.osgi.resolver.XBundleCapability;
import org.jboss.osgi.resolver.XFragmentHostRequirement;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XRequireBundleRequirement;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.spi.AbstractModule;
import org.jboss.osgi.spi.NotImplementedException;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class ModuleExt
implements Module {
    final Logger log = Logger.getLogger(ModuleExt.class);
    private AbstractModule module;
    private Map<String, String> headerMap;
    private List<Capability> capabilities;
    private List<Requirement> requirements;
    private List<Requirement> dynamicreqs;
    private List<Module> fragments;
    private List<Wire> wires;

    public ModuleExt(AbstractModule module) {
        this.module = module;
    }

    AbstractModule getModule() {
        return this.module;
    }

    @Override
    public Map getHeaders() {
        if (this.headerMap == null) {
            this.headerMap = new HashMap<String, String>();
            Dictionary headers = this.getBundle().getHeaders();
            Enumeration keys = headers.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = (String)headers.get(key);
                this.headerMap.put(key, value);
            }
        }
        return Collections.unmodifiableMap(this.headerMap);
    }

    @Override
    public boolean isExtension() {
        return false;
    }

    @Override
    public String getSymbolicName() {
        return this.module.getName();
    }

    @Override
    public Version getVersion() {
        return this.module.getVersion();
    }

    @Override
    public boolean isStale() {
        return false;
    }

    @Override
    public boolean isRemovalPending() {
        return false;
    }

    @Override
    public List<Capability> getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = this.createCapabilities();
        }
        return this.capabilities;
    }

    private List<Capability> createCapabilities() {
        Capability fcap;
        ArrayList<Attribute> attrs;
        ArrayList<CapabilityImpl> result = new ArrayList<CapabilityImpl>();
        String name = this.module.getName();
        Version version = this.module.getVersion();
        if (!this.module.isFragment()) {
            attrs = new ArrayList<Attribute>(2);
            attrs.add(new Attribute("bundle-symbolic-name", name, false));
            attrs.add(new Attribute("bundle-version", version, false));
            fcap = new CapabilityImpl(this, "host", new ArrayList<Directive>(0), attrs);
            result.add((CapabilityImpl)fcap);
        }
        attrs = new ArrayList(2);
        attrs.add(new Attribute("bundle-symbolic-name", name, false));
        attrs.add(new Attribute("bundle-version", version, false));
        fcap = new CapabilityImpl(this, "module", new ArrayList<Directive>(0), attrs);
        XBundleCapability bundleCapability = this.module.getBundleCapability();
        if (bundleCapability == null) {
            throw new IllegalStateException("Cannot obtain XBundleCapability from: " + this.module);
        }
        bundleCapability.addAttachment(Capability.class, (Object)fcap);
        result.add((CapabilityImpl)fcap);
        for (XPackageCapability cap : this.module.getPackageCapabilities()) {
            fcap = this.packageCapability(cap);
            cap.addAttachment(Capability.class, (Object)fcap);
            result.add((CapabilityImpl)fcap);
        }
        for (Module aux : this.getFragments()) {
            for (Capability fragCap : aux.getCapabilities()) {
                fcap = new CapabilityImpl(this, fragCap.getNamespace(), fragCap.getDirectives(), fragCap.getAttributes());
                result.add((CapabilityImpl)fcap);
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Requirement> getRequirements() {
        if (this.requirements == null) {
            this.requirements = this.createRequirements();
        }
        if (this.dynamicreqs == null) {
            this.dynamicreqs = this.createDynamicRequirements();
        }
        return this.requirements;
    }

    private List<Requirement> createRequirements() {
        ArrayList<Requirement> result = new ArrayList<Requirement>();
        for (XRequirement req : this.module.getRequirements()) {
            Requirement freq;
            if (req instanceof XRequireBundleRequirement) {
                freq = this.requireBundleRequiment((XRequireBundleRequirement)req);
                req.addAttachment(Requirement.class, (Object)freq);
                result.add(freq);
                continue;
            }
            if (req instanceof XFragmentHostRequirement) {
                freq = this.fragmentHostRequirement((XFragmentHostRequirement)req);
                req.addAttachment(Requirement.class, (Object)freq);
                result.add(freq);
                continue;
            }
            if (!(req instanceof XPackageRequirement) || ((XPackageRequirement)req).isDynamic()) continue;
            freq = this.packageRequirement((XPackageRequirement)req);
            req.addAttachment(Requirement.class, (Object)freq);
            result.add(freq);
        }
        for (Module auxModule : this.getFragments()) {
            for (Requirement aux : auxModule.getRequirements()) {
                if (!"package".equals(aux.getNamespace()) && !"module".equals(aux.getNamespace())) continue;
                FragmentRequirement req = new FragmentRequirement(this, aux);
                result.add(req);
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Requirement> getDynamicRequirements() {
        if (this.dynamicreqs == null) {
            this.dynamicreqs = this.createDynamicRequirements();
        }
        return this.requirements;
    }

    private List<Requirement> createDynamicRequirements() {
        ArrayList<Requirement> result = new ArrayList<Requirement>();
        for (XPackageRequirement req : this.module.getDynamicPackageRequirements()) {
            Requirement freq = this.packageRequirement(req);
            req.addAttachment(Requirement.class, (Object)freq);
            result.add(freq);
        }
        return Collections.unmodifiableList(result);
    }

    private Capability packageCapability(XPackageCapability cap) {
        String symbolicName = null;
        Version bundleVersion = null;
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        attrs.add(new Attribute("package", cap.getName(), false));
        for (Map.Entry entry : cap.getAttributes().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if ("version".equals(key)) {
                value = Version.parseVersion((String)value.toString());
            } else if ("bundle-symbolic-name".equals(key)) {
                symbolicName = (String)value;
            } else if ("bundle-version".equals(key)) {
                bundleVersion = Version.parseVersion((String)((String)value));
            }
            attrs.add(new Attribute(key, value, false));
        }
        if (symbolicName == null) {
            symbolicName = cap.getModule().getName();
            attrs.add(new Attribute("bundle-symbolic-name", symbolicName, false));
        }
        if (bundleVersion == null) {
            bundleVersion = cap.getModule().getVersion();
            attrs.add(new Attribute("bundle-version", bundleVersion, false));
        }
        ArrayList<Directive> dirs = new ArrayList<Directive>();
        for (Map.Entry entry : cap.getDirectives().entrySet()) {
            dirs.add(new Directive((String)entry.getKey(), entry.getValue()));
        }
        CapabilityImpl fcap = new CapabilityImpl(this, "package", dirs, attrs);
        return fcap;
    }

    private Requirement packageRequirement(XPackageRequirement req) {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        attrs.add(new Attribute("package", req.getName(), false));
        for (Map.Entry entry : req.getAttributes().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if ("version".equals(key)) {
                value = VersionRange.parse((String)value);
            } else if ("bundle-version".equals(key)) {
                value = VersionRange.parse((String)value);
            }
            attrs.add(new Attribute(key, value, false));
        }
        ArrayList<Directive> dirs = new ArrayList<Directive>();
        for (Map.Entry entry : req.getDirectives().entrySet()) {
            dirs.add(new Directive((String)entry.getKey(), entry.getValue()));
        }
        RequirementImpl freq = new RequirementImpl(this, "package", dirs, attrs);
        return freq;
    }

    private Requirement requireBundleRequiment(XRequireBundleRequirement req) {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        attrs.add(new Attribute("bundle-symbolic-name", req.getName(), false));
        for (Map.Entry entry : req.getAttributes().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if ("bundle-version".equals(key)) {
                value = VersionRange.parse((String)value);
            }
            attrs.add(new Attribute(key, value, false));
        }
        ArrayList<Directive> dirs = new ArrayList<Directive>();
        for (Map.Entry entry : req.getDirectives().entrySet()) {
            dirs.add(new Directive((String)entry.getKey(), entry.getValue()));
        }
        RequirementImpl freq = new RequirementImpl(this, "module", dirs, attrs);
        return freq;
    }

    private Requirement fragmentHostRequirement(XFragmentHostRequirement req) {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        attrs.add(new Attribute("bundle-symbolic-name", req.getName(), false));
        for (Map.Entry entry : req.getAttributes().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if ("bundle-version".equals(key)) {
                value = VersionRange.parse((String)value);
            }
            attrs.add(new Attribute(key, value, false));
        }
        ArrayList<Directive> dirs = new ArrayList<Directive>();
        for (Map.Entry entry : req.getDirectives().entrySet()) {
            dirs.add(new Directive((String)entry.getKey(), entry.getValue()));
        }
        RequirementImpl freq = new RequirementImpl(this, "host", dirs, attrs);
        return freq;
    }

    @Override
    public List<R4Library> getNativeLibraries() {
        throw new NotImplementedException();
    }

    @Override
    public int getDeclaredActivationPolicy() {
        throw new NotImplementedException();
    }

    @Override
    public Bundle getBundle() {
        Bundle bundle = (Bundle)this.module.getAttachment(Bundle.class);
        if (bundle == null) {
            throw new IllegalStateException("Cannot obtain the associated bundle from: " + this.module);
        }
        return bundle;
    }

    @Override
    public String getId() {
        return this.getBundle().getLocation();
    }

    @Override
    public List<Wire> getWires() {
        return this.wires != null ? Collections.unmodifiableList(this.wires) : null;
    }

    @Override
    public void setWires(List<Wire> wires) {
        this.wires = wires;
    }

    @Override
    public void attachFragments(List<Module> modules) throws Exception {
        this.fragments = modules;
        this.capabilities = null;
        this.requirements = null;
    }

    @Override
    public List<Module> getFragments() {
        if (this.fragments == null) {
            return Collections.emptyList();
        }
        return this.fragments;
    }

    @Override
    public boolean isResolved() {
        return this.module.isResolved();
    }

    @Override
    public void setResolved() {
    }

    @Override
    public ProtectionDomain getSecurityContext() {
        throw new NotImplementedException();
    }

    @Override
    public boolean impliesDirect(Permission permission) {
        return true;
    }

    @Override
    public Content getContent() {
        throw new NotImplementedException();
    }

    @Override
    public Class<?> getClassByDelegation(String name) throws ClassNotFoundException {
        return this.getBundle().loadClass(name);
    }

    @Override
    public URL getResourceByDelegation(String name) {
        return this.getBundle().getResource(name);
    }

    @Override
    public Enumeration getResourcesByDelegation(String name) {
        try {
            return this.getBundle().getResources(name);
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public URL getEntry(String name) {
        return this.getBundle().getEntry(name);
    }

    @Override
    public boolean hasInputStream(int index, String urlPath) throws IOException {
        throw new NotImplementedException();
    }

    @Override
    public InputStream getInputStream(int index, String urlPath) throws IOException {
        throw new NotImplementedException();
    }

    public Wire getWireForRequirement(Requirement requirement) {
        Wire result = null;
        if (this.wires != null) {
            for (Wire aux : this.wires) {
                Requirement auxreq = aux.getRequirement();
                if (auxreq instanceof FragmentRequirement) {
                    auxreq = ((FragmentRequirement)auxreq).getRequirement();
                }
                if (!auxreq.equals(requirement)) continue;
                result = aux;
                break;
            }
        }
        return result;
    }

    public String toString() {
        return "Module[" + this.getBundle() + "]";
    }
}

