/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.transports.http.configuration.HTTPServerPolicy;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.policy.builder.jaxb.JaxbAssertion;
import org.apache.neethi.Assertion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolicyUtils {
    public static final String HTTPCONF_NAMESPACE = "http://cxf.apache.org/transports/http/configuration";
    public static final QName HTTPCLIENTPOLICY_ASSERTION_QNAME = new QName("http://cxf.apache.org/transports/http/configuration", "client");
    public static final QName HTTPSERVERPOLICY_ASSERTION_QNAME = new QName("http://cxf.apache.org/transports/http/configuration", "server");
    private static final Logger LOG = LogUtils.getL7dLogger(PolicyUtils.class);

    private PolicyUtils() {
    }

    public static HTTPClientPolicy getClient(Message message, HTTPClientPolicy confPolicy) {
        HTTPClientPolicy pol = (HTTPClientPolicy)((Object)message.get(HTTPClientPolicy.class));
        if (pol != null) {
            return PolicyUtils.intersect(pol, confPolicy);
        }
        AssertionInfoMap amap = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        if (null == amap || amap.isEmpty()) {
            return confPolicy;
        }
        Collection ais = (Collection)amap.get((Object)HTTPCLIENTPOLICY_ASSERTION_QNAME);
        if (null == ais) {
            return confPolicy;
        }
        ArrayList<Assertion> alternative = new ArrayList<Assertion>();
        for (AssertionInfo ai : ais) {
            alternative.add(ai.getAssertion());
        }
        HTTPClientPolicy compatible = PolicyUtils.getClient(alternative);
        if (null != compatible && null != confPolicy) {
            if (PolicyUtils.compatible(compatible, confPolicy)) {
                compatible = PolicyUtils.intersect(compatible, confPolicy);
            } else {
                LogUtils.log((Logger)LOG, (Level)Level.SEVERE, (String)"INCOMPATIBLE_HTTPCLIENTPOLICY_ASSERTIONS");
                throw new PolicyException(new org.apache.cxf.common.i18n.Message("INCOMPATIBLE_HTTPCLIENTPOLICY_ASSERTIONS", LOG, new Object[0]));
            }
        }
        return compatible;
    }

    public static HTTPServerPolicy getServer(Message message, HTTPServerPolicy confPolicy) {
        AssertionInfoMap amap = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        if (null == amap) {
            return confPolicy;
        }
        Collection ais = (Collection)amap.get((Object)HTTPSERVERPOLICY_ASSERTION_QNAME);
        if (null == ais) {
            return confPolicy;
        }
        ArrayList<Assertion> alternative = new ArrayList<Assertion>();
        for (AssertionInfo ai : ais) {
            alternative.add(ai.getAssertion());
        }
        HTTPServerPolicy compatible = PolicyUtils.getServer(alternative);
        if (null != compatible && null != confPolicy) {
            if (PolicyUtils.compatible(compatible, confPolicy)) {
                compatible = PolicyUtils.intersect(compatible, confPolicy);
            } else {
                LogUtils.log((Logger)LOG, (Level)Level.SEVERE, (String)"INCOMPATIBLE_HTTPSERVERPOLICY_ASSERTIONS");
                throw new PolicyException(new org.apache.cxf.common.i18n.Message("INCOMPATIBLE_HTTPSERVERPOLICY_ASSERTIONS", LOG, new Object[0]));
            }
        }
        return compatible;
    }

    public static HTTPClientPolicy getClient(PolicyEngine pe, EndpointInfo ei, Conduit c) {
        Collection alternative = pe.getClientEndpointPolicy(ei, c).getChosenAlternative();
        HTTPClientPolicy compatible = null;
        for (Assertion a : alternative) {
            if (!HTTPCLIENTPOLICY_ASSERTION_QNAME.equals(a.getName())) continue;
            HTTPClientPolicy p = (HTTPClientPolicy)((Object)JaxbAssertion.cast((Assertion)a, HTTPClientPolicy.class).getData());
            if (null == compatible) {
                compatible = p;
                continue;
            }
            if (null != (compatible = PolicyUtils.intersect(compatible, p))) continue;
            LogUtils.log((Logger)LOG, (Level)Level.SEVERE, (String)"INCOMPATIBLE_HTTPCLIENTPOLICY_ASSERTIONS");
            throw new PolicyException(new org.apache.cxf.common.i18n.Message("INCOMPATIBLE_HTTPCLIENTPOLICY_ASSERTIONS", LOG, new Object[0]));
        }
        return compatible;
    }

    public static HTTPServerPolicy getServer(PolicyEngine pe, EndpointInfo ei, Destination d) {
        Collection alternative = pe.getServerEndpointPolicy(ei, d).getChosenAlternative();
        HTTPServerPolicy compatible = null;
        for (Assertion a : alternative) {
            if (!HTTPSERVERPOLICY_ASSERTION_QNAME.equals(a.getName())) continue;
            HTTPServerPolicy p = (HTTPServerPolicy)((Object)JaxbAssertion.cast((Assertion)a, HTTPServerPolicy.class).getData());
            if (null == compatible) {
                compatible = p;
                continue;
            }
            if (null != (compatible = PolicyUtils.intersect(compatible, p))) continue;
            LogUtils.log((Logger)LOG, (Level)Level.SEVERE, (String)"INCOMPATIBLE_HTTPSERVERPOLICY_ASSERTIONS");
            throw new PolicyException(new org.apache.cxf.common.i18n.Message("INCOMPATIBLE_HTTPSERVERPOLICY_ASSERTIONS", LOG, new Object[0]));
        }
        return compatible;
    }

    public static void assertClientPolicy(Message message, HTTPClientPolicy client) {
        AssertionInfoMap aim;
        HTTPClientPolicy pol = (HTTPClientPolicy)((Object)message.get(HTTPClientPolicy.class));
        if (pol != null) {
            client = PolicyUtils.intersect(pol, client);
        }
        if (null == (aim = (AssertionInfoMap)message.get(AssertionInfoMap.class))) {
            return;
        }
        Collection ais = (Collection)aim.get((Object)HTTPCLIENTPOLICY_ASSERTION_QNAME);
        if (null == ais || ais.size() == 0) {
            return;
        }
        if (MessageUtils.isOutbound((Message)message)) {
            for (AssertionInfo ai : ais) {
                HTTPClientPolicy p = (HTTPClientPolicy)((Object)JaxbAssertion.cast((Assertion)ai.getAssertion(), HTTPClientPolicy.class).getData());
                if (!PolicyUtils.compatible(p, client)) continue;
                ai.setAsserted(true);
            }
        } else {
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
            }
        }
    }

    public static void assertServerPolicy(Message message, HTTPServerPolicy server) {
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        if (null == aim) {
            return;
        }
        Collection ais = (Collection)aim.get((Object)HTTPSERVERPOLICY_ASSERTION_QNAME);
        if (null == ais || ais.size() == 0) {
            return;
        }
        if (MessageUtils.isOutbound((Message)message)) {
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
            }
        } else {
            for (AssertionInfo ai : ais) {
                HTTPServerPolicy p = (HTTPServerPolicy)((Object)JaxbAssertion.cast((Assertion)ai.getAssertion(), HTTPServerPolicy.class).getData());
                if (!PolicyUtils.equals(p, server)) continue;
                ai.setAsserted(true);
            }
        }
    }

    public static boolean compatible(HTTPClientPolicy p1, HTTPClientPolicy p2) {
        if (p1 == p2 || ((Object)((Object)p1)).equals((Object)p2)) {
            return true;
        }
        boolean compatible = true;
        if (compatible) {
            compatible &= PolicyUtils.compatible(p1.getAccept(), p2.getAccept());
        }
        if (compatible) {
            compatible &= PolicyUtils.compatible(p1.getAcceptEncoding(), p2.getAcceptEncoding());
        }
        if (compatible) {
            compatible &= PolicyUtils.compatible(p1.getAcceptLanguage(), p2.getAcceptLanguage());
        }
        if (compatible) {
            compatible &= PolicyUtils.compatible(p1.getBrowserType(), p2.getBrowserType());
        }
        if (compatible) {
            compatible &= !p1.isSetCacheControl() || !p2.isSetCacheControl() || p1.getCacheControl().equals(p2.getCacheControl());
        }
        if (compatible) {
            boolean bl = compatible = !p1.isSetConnection() || !p2.isSetConnection() || p1.getConnection().value().equals(p2.getConnection().value());
        }
        if (compatible) {
            boolean bl = compatible = !p1.isSetContentType() || !p2.isSetContentType() || p1.getContentType().equals(p2.getContentType());
        }
        if (compatible) {
            compatible &= PolicyUtils.compatible(p1.getCookie(), p2.getCookie());
        }
        if (compatible) {
            compatible &= PolicyUtils.compatible(p1.getDecoupledEndpoint(), p2.getDecoupledEndpoint());
        }
        if (compatible) {
            compatible &= PolicyUtils.compatible(p1.getHost(), p2.getHost());
        }
        if (compatible) {
            compatible &= PolicyUtils.compatible(p1.getProxyServer(), p2.getProxyServer());
        }
        if (compatible) {
            compatible &= !p1.isSetProxyServerPort() || !p2.isSetProxyServerPort() || p1.getProxyServerPort() == p2.getProxyServerPort();
        }
        if (compatible) {
            compatible &= !p1.isSetProxyServerType() || !p2.isSetProxyServerType() || p1.getProxyServerType().equals((Object)p2.getProxyServerType());
        }
        if (compatible) {
            compatible &= PolicyUtils.compatible(p1.getReferer(), p2.getReferer());
        }
        if (compatible) {
            compatible &= p1.isAllowChunking() == p2.isAllowChunking();
        }
        if (compatible) {
            compatible &= p1.isAutoRedirect() == p2.isAutoRedirect();
        }
        return compatible;
    }

    public static HTTPClientPolicy intersect(HTTPClientPolicy p1, HTTPClientPolicy p2) {
        if (!PolicyUtils.compatible(p1, p2)) {
            return null;
        }
        HTTPClientPolicy p = new HTTPClientPolicy();
        p.setAccept(PolicyUtils.combine(p1.getAccept(), p2.getAccept()));
        p.setAcceptEncoding(PolicyUtils.combine(p1.getAcceptEncoding(), p2.getAcceptEncoding()));
        p.setAcceptLanguage(PolicyUtils.combine(p1.getAcceptLanguage(), p2.getAcceptLanguage()));
        if (p1.isSetAllowChunking()) {
            p.setAllowChunking(p1.isAllowChunking());
        } else if (p2.isSetAllowChunking()) {
            p.setAllowChunking(p2.isAllowChunking());
        }
        if (p1.isSetAutoRedirect()) {
            p.setAutoRedirect(p1.isAutoRedirect());
        } else if (p2.isSetAutoRedirect()) {
            p.setAutoRedirect(p2.isAutoRedirect());
        }
        p.setBrowserType(PolicyUtils.combine(p1.getBrowserType(), p2.getBrowserType()));
        if (p1.isSetCacheControl()) {
            p.setCacheControl(p1.getCacheControl());
        } else if (p2.isSetCacheControl()) {
            p.setCacheControl(p2.getCacheControl());
        }
        if (p1.isSetConnection()) {
            p.setConnection(p1.getConnection());
        } else if (p2.isSetConnection()) {
            p.setConnection(p2.getConnection());
        }
        if (p1.isSetContentType()) {
            p.setContentType(p1.getContentType());
        } else if (p2.isSetContentType()) {
            p.setContentType(p2.getContentType());
        }
        p.setCookie(PolicyUtils.combine(p1.getCookie(), p2.getCookie()));
        p.setDecoupledEndpoint(PolicyUtils.combine(p1.getDecoupledEndpoint(), p2.getDecoupledEndpoint()));
        p.setHost(PolicyUtils.combine(p1.getHost(), p2.getHost()));
        p.setProxyServer(PolicyUtils.combine(p1.getProxyServer(), p2.getProxyServer()));
        if (p1.isSetProxyServerPort()) {
            p.setProxyServerPort(p1.getProxyServerPort());
        } else if (p2.isSetProxyServerPort()) {
            p.setProxyServerPort(p2.getProxyServerPort());
        }
        if (p1.isSetProxyServerType()) {
            p.setProxyServerType(p1.getProxyServerType());
        } else if (p2.isSetProxyServerType()) {
            p.setProxyServerType(p2.getProxyServerType());
        }
        p.setReferer(PolicyUtils.combine(p1.getReferer(), p2.getReferer()));
        if (p1.isSetConnectionTimeout() || p2.isSetConnectionTimeout()) {
            p.setConnectionTimeout(Math.min(p1.getConnectionTimeout(), p2.getConnectionTimeout()));
        }
        if (p1.isSetReceiveTimeout() || p2.isSetReceiveTimeout()) {
            p.setReceiveTimeout(Math.min(p1.getReceiveTimeout(), p2.getReceiveTimeout()));
        }
        return p;
    }

    public static boolean equals(HTTPClientPolicy p1, HTTPClientPolicy p2) {
        if (p1 == p2) {
            return true;
        }
        boolean result = true;
        if (!(result &= p1.isAllowChunking() == p2.isAllowChunking() && p1.isAutoRedirect() == p2.isAutoRedirect() && PolicyUtils.equals(p1.getAccept(), p2.getAccept()) && PolicyUtils.equals(p1.getAcceptEncoding(), p2.getAcceptEncoding()) && PolicyUtils.equals(p1.getAcceptLanguage(), p2.getAcceptLanguage()) && PolicyUtils.equals(p1.getBrowserType(), p2.getBrowserType()))) {
            return false;
        }
        if (!(result &= (p1.getCacheControl() == null ? p2.getCacheControl() == null : p1.getCacheControl().equals(p2.getCacheControl()) && p1.getConnection().value().equals(p2.getConnection().value())) && p1.getConnectionTimeout() == p2.getConnectionTimeout() && PolicyUtils.equals(p1.getContentType(), p2.getContentType()) && PolicyUtils.equals(p1.getCookie(), p2.getCookie()) && PolicyUtils.equals(p1.getDecoupledEndpoint(), p2.getDecoupledEndpoint()) && PolicyUtils.equals(p1.getHost(), p2.getHost()))) {
            return false;
        }
        return result &= PolicyUtils.equals(p1.getProxyServer(), p2.getProxyServer()) && (p1.isSetProxyServerPort() ? p1.getProxyServerPort() == p2.getProxyServerPort() : !p2.isSetProxyServerPort()) && p1.getProxyServerType().value().equals(p2.getProxyServerType().value()) && p1.getReceiveTimeout() == p2.getReceiveTimeout() && PolicyUtils.equals(p1.getReferer(), p2.getReferer());
    }

    public static boolean compatible(HTTPServerPolicy p1, HTTPServerPolicy p2) {
        if (p1 == p2 || ((Object)((Object)p1)).equals((Object)p2)) {
            return true;
        }
        boolean compatible = true;
        if (compatible) {
            compatible &= !p1.isSetCacheControl() || !p2.isSetCacheControl() || p1.getCacheControl().equals(p2.getCacheControl());
        }
        if (compatible) {
            compatible &= PolicyUtils.compatible(p1.getContentEncoding(), p2.getContentEncoding());
        }
        if (compatible) {
            compatible &= PolicyUtils.compatible(p1.getContentLocation(), p2.getContentLocation());
        }
        if (compatible) {
            compatible &= PolicyUtils.compatible(p1.getContentType(), p2.getContentType());
        }
        if (compatible) {
            compatible &= PolicyUtils.compatible(p1.getRedirectURL(), p2.getRedirectURL());
        }
        if (compatible) {
            compatible &= PolicyUtils.compatible(p1.getServerType(), p2.getServerType());
        }
        if (compatible) {
            compatible &= p1.isHonorKeepAlive() == p2.isHonorKeepAlive();
        }
        if (compatible) {
            compatible &= p1.isSuppressClientReceiveErrors() == p2.isSuppressClientReceiveErrors();
        }
        if (compatible) {
            compatible &= p1.isSuppressClientSendErrors() == p2.isSuppressClientSendErrors();
        }
        if (compatible) {
            compatible &= PolicyUtils.compatible(p1.getKeepAliveParameters(), p2.getKeepAliveParameters());
        }
        return compatible;
    }

    public static HTTPServerPolicy intersect(HTTPServerPolicy p1, HTTPServerPolicy p2) {
        if (!PolicyUtils.compatible(p1, p2)) {
            return null;
        }
        HTTPServerPolicy p = new HTTPServerPolicy();
        if (p1.isSetCacheControl()) {
            p.setCacheControl(p1.getCacheControl());
        } else if (p2.isSetCacheControl()) {
            p.setCacheControl(p2.getCacheControl());
        }
        p.setContentEncoding(PolicyUtils.combine(p1.getContentEncoding(), p2.getContentEncoding()));
        p.setContentLocation(PolicyUtils.combine(p1.getContentLocation(), p2.getContentLocation()));
        if (p1.isSetContentType()) {
            p.setContentType(p1.getContentType());
        } else if (p2.isSetContentType()) {
            p.setContentType(p2.getContentType());
        }
        if (p1.isSetHonorKeepAlive()) {
            p.setHonorKeepAlive(p1.isHonorKeepAlive());
        } else if (p2.isSetHonorKeepAlive()) {
            p.setHonorKeepAlive(p2.isHonorKeepAlive());
        }
        if (p1.isSetKeepAliveParameters()) {
            p.setKeepAliveParameters(p1.getKeepAliveParameters());
        } else if (p2.isSetKeepAliveParameters()) {
            p.setKeepAliveParameters(p2.getKeepAliveParameters());
        }
        if (p1.isSetReceiveTimeout() || p2.isSetReceiveTimeout()) {
            p.setReceiveTimeout(Math.min(p1.getReceiveTimeout(), p2.getReceiveTimeout()));
        }
        p.setRedirectURL(PolicyUtils.combine(p1.getRedirectURL(), p2.getRedirectURL()));
        p.setServerType(PolicyUtils.combine(p1.getServerType(), p2.getServerType()));
        if (p1.isSetSuppressClientReceiveErrors()) {
            p.setSuppressClientReceiveErrors(p1.isSuppressClientReceiveErrors());
        } else if (p2.isSetSuppressClientReceiveErrors()) {
            p.setSuppressClientReceiveErrors(p2.isSuppressClientReceiveErrors());
        }
        if (p1.isSetSuppressClientSendErrors()) {
            p.setSuppressClientSendErrors(p1.isSuppressClientSendErrors());
        } else if (p2.isSetSuppressClientSendErrors()) {
            p.setSuppressClientSendErrors(p2.isSuppressClientSendErrors());
        }
        return p;
    }

    public static boolean equals(HTTPServerPolicy p1, HTTPServerPolicy p2) {
        if (p1 == p2) {
            return true;
        }
        boolean result = true;
        if (!(result &= p1.isHonorKeepAlive() == p2.isHonorKeepAlive() && (p1.getCacheControl() == null ? p2.getCacheControl() == null : p1.getCacheControl().equals(p2.getCacheControl())) && PolicyUtils.equals(p1.getContentEncoding(), p2.getContentEncoding()) && PolicyUtils.equals(p1.getContentLocation(), p2.getContentLocation()) && PolicyUtils.equals(p1.getContentType(), p2.getContentType()) && PolicyUtils.equals(p1.getKeepAliveParameters(), p2.getKeepAliveParameters()))) {
            return false;
        }
        return result &= p1.getReceiveTimeout() == p2.getReceiveTimeout() && PolicyUtils.equals(p1.getRedirectURL(), p2.getRedirectURL()) && PolicyUtils.equals(p1.getServerType(), p2.getServerType()) && p1.isSuppressClientReceiveErrors() == p2.isSuppressClientReceiveErrors() && p1.isSuppressClientSendErrors() == p2.isSuppressClientSendErrors();
    }

    private static String combine(String s1, String s2) {
        return s1 == null ? s2 : s1;
    }

    private static boolean equals(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    private static boolean compatible(String s1, String s2) {
        return s1 == null || s2 == null || s1.equals(s2);
    }

    private static HTTPClientPolicy getClient(Collection<Assertion> alternative) {
        HTTPClientPolicy compatible = null;
        for (Assertion a : alternative) {
            if (!HTTPCLIENTPOLICY_ASSERTION_QNAME.equals(a.getName())) continue;
            HTTPClientPolicy p = (HTTPClientPolicy)((Object)JaxbAssertion.cast((Assertion)a, HTTPClientPolicy.class).getData());
            if (null == compatible) {
                compatible = p;
                continue;
            }
            if (null != (compatible = PolicyUtils.intersect(compatible, p))) continue;
            LogUtils.log((Logger)LOG, (Level)Level.SEVERE, (String)"INCOMPATIBLE_HTTPCLIENTPOLICY_ASSERTIONS");
            org.apache.cxf.common.i18n.Message m = new org.apache.cxf.common.i18n.Message("INCOMPATIBLE_HTTPCLIENTPOLICY_ASSERTIONS", LOG, new Object[0]);
            throw new PolicyException(m);
        }
        return compatible;
    }

    private static HTTPServerPolicy getServer(Collection<Assertion> alternative) {
        HTTPServerPolicy compatible = null;
        for (Assertion a : alternative) {
            if (!HTTPSERVERPOLICY_ASSERTION_QNAME.equals(a.getName())) continue;
            HTTPServerPolicy p = (HTTPServerPolicy)((Object)JaxbAssertion.cast((Assertion)a, HTTPServerPolicy.class).getData());
            if (null == compatible) {
                compatible = p;
                continue;
            }
            if (null != (compatible = PolicyUtils.intersect(compatible, p))) continue;
            LogUtils.log((Logger)LOG, (Level)Level.SEVERE, (String)"INCOMPATIBLE_HTTPSERVERPOLICY_ASSERTIONS");
            org.apache.cxf.common.i18n.Message m = new org.apache.cxf.common.i18n.Message("INCOMPATIBLE_HTTPSERVERPOLICY_ASSERTIONS", LOG, new Object[0]);
            throw new PolicyException(m);
        }
        return compatible;
    }

    public static String toString(HTTPClientPolicy p) {
        StringBuilder buf = new StringBuilder();
        buf.append((Object)p);
        buf.append("[DecoupledEndpoint=\"");
        buf.append(p.getDecoupledEndpoint());
        buf.append("\", ReceiveTimeout=");
        buf.append(p.getReceiveTimeout());
        buf.append("])");
        return buf.toString();
    }

    public static String toString(HTTPServerPolicy p) {
        StringBuilder buf = new StringBuilder();
        buf.append((Object)p);
        buf.append("[ContentType=\"");
        buf.append(p.getContentType());
        buf.append("\", ReceiveTimeout=");
        buf.append(p.getReceiveTimeout());
        buf.append("])");
        return buf.toString();
    }
}

