/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.Arrays;
import java.util.List;
import org.hornetq.api.jms.management.JMSQueueControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class JMSQueueReadAttributeHandler
extends AbstractRuntimeOnlyHandler {
    public static final JMSQueueReadAttributeHandler INSTANCE = new JMSQueueReadAttributeHandler();
    public static final List<String> METRICS = Arrays.asList("message-count", "scheduled-count", "consumer-count", "delivering-count", "messages-added");
    public static final List<String> READ_ATTRIBUTES = Arrays.asList(CommonAttributes.QUEUE_ADDRESS.getName(), CommonAttributes.EXPIRY_ADDRESS.getName(), CommonAttributes.DEAD_LETTER_ADDRESS.getName(), "paused", "temporary");
    private ParametersValidator validator = new ParametersValidator();

    private JMSQueueReadAttributeHandler() {
        this.validator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1));
    }

    public void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validator.validate(operation);
        String attributeName = operation.require("name").asString();
        String queueName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController hqService = context.getServiceRegistry(false).getService(hqServiceName);
        HornetQServer hqServer = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
        JMSQueueControl control = (JMSQueueControl)JMSQueueControl.class.cast(hqServer.getManagementService().getResource("jms.queue." + queueName));
        if ("message-count".equals(attributeName)) {
            try {
                context.getResult().set(control.getMessageCount());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if ("scheduled-count".equals(attributeName)) {
            context.getResult().set(control.getScheduledCount());
        } else if ("consumer-count".equals(attributeName)) {
            context.getResult().set(control.getConsumerCount());
        } else if ("delivering-count".equals(attributeName)) {
            context.getResult().set(control.getDeliveringCount());
        } else if ("messages-added".equals(attributeName)) {
            context.getResult().set(control.getMessagesAdded());
        } else if (CommonAttributes.QUEUE_ADDRESS.getName().equals(attributeName)) {
            context.getResult().set(control.getAddress());
        } else if (CommonAttributes.EXPIRY_ADDRESS.getName().equals(attributeName)) {
            context.getResult().set(control.getExpiryAddress());
        } else if (CommonAttributes.DEAD_LETTER_ADDRESS.getName().equals(attributeName)) {
            context.getResult().set(control.getDeadLetterAddress());
        } else if ("paused".equals(attributeName)) {
            try {
                context.getResult().set(control.isPaused());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if ("temporary".equals(attributeName)) {
            context.getResult().set(control.isTemporary());
        } else if (METRICS.contains(attributeName) || READ_ATTRIBUTES.contains(attributeName)) {
            throw MessagingMessages.MESSAGES.unsupportedAttribute(attributeName);
        }
        context.completeStep();
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        for (String attr : READ_ATTRIBUTES) {
            registration.registerReadOnlyAttribute(attr, (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
        for (String metric : METRICS) {
            registration.registerMetric(metric, (OperationStepHandler)this);
        }
    }
}

