/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Properties;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.infinispan.util.TypedProperties;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class IndexingConfigurationBuilder
extends AbstractConfigurationChildBuilder<IndexingConfiguration> {
    private static final Log log = LogFactory.getLog(IndexingConfigurationBuilder.class);
    private boolean enabled = false;
    private boolean indexLocalOnly = false;
    private Properties properties = new Properties();

    IndexingConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public IndexingConfigurationBuilder enable() {
        this.enabled = true;
        return this;
    }

    public IndexingConfigurationBuilder disable() {
        this.enabled = false;
        return this;
    }

    public IndexingConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public IndexingConfigurationBuilder indexLocalOnly(boolean b) {
        this.indexLocalOnly = b;
        return this;
    }

    public IndexingConfigurationBuilder addProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public IndexingConfigurationBuilder withProperties(Properties props) {
        this.properties = props;
        return this;
    }

    @Override
    void validate() {
        if (this.enabled) {
            try {
                Util.loadClassStrict("org.infinispan.query.Search", this.getBuilder().classLoader());
            }
            catch (ClassNotFoundException e) {
                log.warnf("Indexing can only be enabled if infinispan-query.jar is available on your classpath, and this jar has not been detected. Intended behavior may not be exhibited.", new Object[0]);
            }
        }
    }

    @Override
    IndexingConfiguration create() {
        return new IndexingConfiguration(TypedProperties.toTypedProperties(this.properties), this.enabled, this.indexLocalOnly);
    }

    public IndexingConfigurationBuilder read(IndexingConfiguration template) {
        this.enabled = template.enabled();
        this.indexLocalOnly = template.indexLocalOnly();
        this.properties = template.properties();
        return this;
    }

    public String toString() {
        return "IndexingConfigurationBuilder{enabled=" + this.enabled + ", indexLocalOnly=" + this.indexLocalOnly + ", properties=" + this.properties + '}';
    }
}

