/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.util;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;

public class UnmodifiableDictionary<K, V>
extends Dictionary<K, V>
implements Serializable {
    private static final long serialVersionUID = -6793757957920326746L;
    private final Dictionary<K, V> delegate;

    public UnmodifiableDictionary(Dictionary<K, V> props) {
        if (props == null) {
            throw new IllegalArgumentException("Null props");
        }
        this.delegate = new Hashtable();
        Enumeration<K> keys = props.keys();
        while (keys.hasMoreElements()) {
            K key = keys.nextElement();
            V val = props.get(key);
            this.delegate.put(key, val);
        }
    }

    @Override
    public Enumeration<V> elements() {
        return this.delegate.elements();
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Enumeration<K> keys() {
        return this.delegate.keys();
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

