/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.Handler;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.filters.DenyAllFilter;

class Handlers {
    public static final Logger ROOT = Logger.getLogger((String)"ROOT");
    public static final Logger.AttachmentKey<Map<String, Filter>> DISABLED_HANDLERS_KEY = new Logger.AttachmentKey();
    private static final Object HANDLER_LOCK = new Object();

    Handlers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void enableHandler(Handler handler, String handlerName) {
        Map disableHandlers = (Map)ROOT.getAttachment(DISABLED_HANDLERS_KEY);
        if (disableHandlers != null && disableHandlers.containsKey(handlerName)) {
            Object object = HANDLER_LOCK;
            synchronized (object) {
                Filter filter = (Filter)disableHandlers.get(handlerName);
                handler.setFilter(filter);
                disableHandlers.remove(handlerName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disableHandler(Handler handler, String handlerName) {
        Map current;
        Map<String, Filter> disableHandlers = (HashMap<String, Filter>)ROOT.getAttachment(DISABLED_HANDLERS_KEY);
        if (disableHandlers == null && (current = (Map)ROOT.attachIfAbsent(DISABLED_HANDLERS_KEY, disableHandlers = new HashMap<String, Filter>())) != null) {
            disableHandlers = current;
        }
        Object object = HANDLER_LOCK;
        synchronized (object) {
            if (!disableHandlers.containsKey(handlerName)) {
                disableHandlers.put(handlerName, handler.getFilter());
                handler.setFilter((Filter)DenyAllFilter.getInstance());
            }
        }
    }
}

