/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.logging.CommonAttributes;

public enum Element {
    UNKNOWN((String)null),
    ACCEPT((AttributeDefinition)CommonAttributes.ACCEPT),
    ALL((AttributeDefinition)CommonAttributes.ALL),
    ANY((AttributeDefinition)CommonAttributes.ANY),
    APPEND((AttributeDefinition)CommonAttributes.APPEND),
    ASYNC_HANDLER("async-handler"),
    CHANGE_LEVEL((AttributeDefinition)CommonAttributes.CHANGE_LEVEL),
    CONSOLE_HANDLER("console-handler"),
    CUSTOM_HANDLER("custom-handler"),
    DENY((AttributeDefinition)CommonAttributes.DENY),
    ENCODING((AttributeDefinition)CommonAttributes.ENCODING),
    FILE((AttributeDefinition)CommonAttributes.FILE),
    FILE_HANDLER("file-handler"),
    FILTER((AttributeDefinition)CommonAttributes.FILTER),
    FORMATTER((AttributeDefinition)CommonAttributes.FORMATTER),
    HANDLER((AttributeDefinition)CommonAttributes.HANDLER),
    HANDLERS((AttributeDefinition)CommonAttributes.HANDLERS),
    LEVEL((AttributeDefinition)CommonAttributes.LEVEL),
    LEVEL_RANGE((AttributeDefinition)CommonAttributes.LEVEL_RANGE),
    LOGGER("logger"),
    MATCH((AttributeDefinition)CommonAttributes.MATCH),
    MAX_BACKUP_INDEX((AttributeDefinition)CommonAttributes.MAX_BACKUP_INDEX),
    NOT((AttributeDefinition)CommonAttributes.NOT),
    OVERFLOW_ACTION((AttributeDefinition)CommonAttributes.OVERFLOW_ACTION),
    PATTERN_FORMATTER("pattern-formatter"),
    PERIODIC_ROTATING_FILE_HANDLER("periodic-rotating-file-handler"),
    PROPERTIES("properties"),
    PROPERTY((AttributeDefinition)CommonAttributes.PROPERTY),
    QUEUE_LENGTH((AttributeDefinition)CommonAttributes.QUEUE_LENGTH),
    REPLACE((AttributeDefinition)CommonAttributes.REPLACE),
    ROOT_LOGGER("root-logger"),
    ROTATE_SIZE((AttributeDefinition)CommonAttributes.ROTATE_SIZE),
    SIZE_ROTATING_FILE_HANDLER("size-rotating-file-handler"),
    SUBHANDLERS((AttributeDefinition)CommonAttributes.SUBHANDLERS),
    SUFFIX((AttributeDefinition)CommonAttributes.SUFFIX),
    TARGET((AttributeDefinition)CommonAttributes.TARGET);

    private final String name;
    private final AttributeDefinition definition;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
        this.definition = null;
    }

    private Element(AttributeDefinition definition) {
        this.name = definition.getXmlName();
        this.definition = definition;
    }

    public String getLocalName() {
        return this.name;
    }

    public boolean hasDefinition() {
        return this.definition != null;
    }

    public AttributeDefinition getDefinition() {
        return this.definition;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

