/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.service;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.appclient.logging.AppClientLogger;
import org.jboss.ejb.client.ContextSelector;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.remoting.IoFutureHelper;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.Remoting;
import org.jboss.remoting3.remote.RemoteConnectionProviderFactory;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.xnio.IoFuture;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

public class LazyConnectionContextSelector
implements ContextSelector<EJBClientContext> {
    private final String hostUrl;
    private final CallbackHandler callbackHandler;
    private Endpoint endpoint;
    private Connection connection;
    private volatile EJBClientContext clientContext;

    public LazyConnectionContextSelector(String hostUrl, CallbackHandler callbackHandler) {
        this.hostUrl = hostUrl;
        this.callbackHandler = callbackHandler;
    }

    private synchronized void createConnection() {
        try {
            this.endpoint = Remoting.createEndpoint((String)"endpoint", (OptionMap)OptionMap.EMPTY);
            this.endpoint.addConnectionProvider("remote", (ConnectionProviderFactory)new RemoteConnectionProviderFactory(), OptionMap.create((Option)Options.SSL_ENABLED, (Object)Boolean.FALSE));
            IoFuture futureConnection = this.endpoint.connect(new URI(this.hostUrl), OptionMap.create((Option)Options.SASL_POLICY_NOANONYMOUS, (Object)Boolean.FALSE, (Option)Options.SASL_POLICY_NOPLAINTEXT, (Object)Boolean.FALSE), this.callbackHandler);
            this.connection = (Connection)IoFutureHelper.get((IoFuture)futureConnection, (long)30L, (TimeUnit)TimeUnit.SECONDS);
            EJBClientContext ejbClientContext = EJBClientContext.create();
            ejbClientContext.registerConnection(this.connection);
            this.clientContext = ejbClientContext;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EJBClientContext getCurrent() {
        if (this.clientContext == null) {
            LazyConnectionContextSelector lazyConnectionContextSelector = this;
            synchronized (lazyConnectionContextSelector) {
                if (this.clientContext == null) {
                    this.createConnection();
                }
            }
        }
        return this.clientContext;
    }

    public synchronized void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (IOException e) {
            AppClientLogger.ROOT_LOGGER.exceptionClosingConnection(e);
        }
        try {
            if (this.endpoint != null) {
                this.endpoint.close();
            }
        }
        catch (IOException e) {
            AppClientLogger.ROOT_LOGGER.exceptionClosingConnection(e);
        }
    }
}

