/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.consistenthash;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.client.hotrod.impl.ConfigurationProperties;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.util.Util;
import org.infinispan.util.logging.BasicLogFactory;
import org.jboss.logging.BasicLogger;

public class ConsistentHashFactory {
    private static final BasicLogger log = BasicLogFactory.getLog(ConsistentHashFactory.class);
    private final Map<Integer, String> version2ConsistentHash = new HashMap<Integer, String>();
    private ClassLoader classLoader;

    public void init(ConfigurationProperties config, ClassLoader classLoader) {
        this.classLoader = classLoader;
        for (String propName : config.getProperties().stringPropertyNames()) {
            if (!propName.startsWith("infinispan.client.hotrod.hash_function_impl")) continue;
            if (log.isTraceEnabled()) {
                log.tracef("Processing consistent hash: %s", (Object)propName);
            }
            String versionString = propName.substring("infinispan.client.hotrod.hash_function_impl.".length());
            int version = Integer.parseInt(versionString);
            String hashFunction = config.getProperties().getProperty(propName);
            this.version2ConsistentHash.put(version, hashFunction);
            if (!log.isTraceEnabled()) continue;
            log.tracef("Added consistent hash version %d: %s", (Object)version, (Object)hashFunction);
        }
    }

    public ConsistentHash newConsistentHash(int version) {
        String hashFunctionClass = this.version2ConsistentHash.get(version);
        if (hashFunctionClass == null) {
            if (log.isTraceEnabled()) {
                log.tracef("No hash function configured for version %d", (Object)version);
            }
            hashFunctionClass = ConsistentHashFactory.class.getPackage().getName() + ".ConsistentHashV" + version;
            if (log.isTraceEnabled()) {
                log.tracef("Trying to use default value: %s", (Object)hashFunctionClass);
            }
            this.version2ConsistentHash.put(version, hashFunctionClass);
        }
        return (ConsistentHash)Util.getInstance((String)hashFunctionClass, (ClassLoader)this.classLoader);
    }

    public Map<Integer, String> getVersion2ConsistentHash() {
        return Collections.unmodifiableMap(this.version2ConsistentHash);
    }
}

