/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.io.IOException;
import java.security.acl.Group;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;
import org.jboss.security.auth.spi.Util;
import org.jboss.security.util.StringPropertyReplacer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsersRolesLoginModule
extends UsernamePasswordLoginModule {
    private String defaultUsersRsrcName = "defaultUsers.properties";
    private String defaultRolesRsrcName = "defaultRoles.properties";
    private String usersRsrcName = "users.properties";
    private String rolesRsrcName = "roles.properties";
    private Properties users;
    private Properties roles;
    private char roleGroupSeperator = (char)46;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        try {
            String option = (String)options.get("usersProperties");
            if (option != null) {
                this.usersRsrcName = StringPropertyReplacer.replaceProperties(option);
            }
            if ((option = (String)options.get("defaultUsersProperties")) != null) {
                this.defaultUsersRsrcName = StringPropertyReplacer.replaceProperties(option);
            }
            if ((option = (String)options.get("rolesProperties")) != null) {
                this.rolesRsrcName = StringPropertyReplacer.replaceProperties(option);
            }
            if ((option = (String)options.get("defaultRolesProperties")) != null) {
                this.defaultRolesRsrcName = StringPropertyReplacer.replaceProperties(option);
            }
            if ((option = (String)options.get("roleGroupSeperator")) != null) {
                this.roleGroupSeperator = option.charAt(0);
            }
            this.users = this.createUsers(options);
            this.roles = this.createRoles(options);
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to load users/passwords/role files", (Throwable)e);
        }
    }

    @Override
    public boolean login() throws LoginException {
        if (this.users == null) {
            throw new LoginException("PB00015: Null Value:Missing users.properties file.");
        }
        if (this.roles == null) {
            throw new LoginException("PB00015: Null Value:Missing roles.properties file.");
        }
        return super.login();
    }

    @Override
    protected Group[] getRoleSets() throws LoginException {
        String targetUser = this.getUsername();
        Group[] roleSets = Util.getRoleSets(targetUser, this.roles, this.roleGroupSeperator, (AbstractServerLoginModule)this);
        return roleSets;
    }

    @Override
    protected String getUsersPassword() {
        String username = this.getUsername();
        String password = null;
        if (username != null) {
            password = this.users.getProperty(username, null);
        }
        return password;
    }

    protected void loadUsers() throws IOException {
        this.users = Util.loadProperties(this.defaultUsersRsrcName, this.usersRsrcName, this.log);
    }

    protected Properties createUsers(Map<String, ?> options) throws IOException {
        this.loadUsers();
        return this.users;
    }

    protected void loadRoles() throws IOException {
        this.roles = Util.loadProperties(this.defaultRolesRsrcName, this.rolesRsrcName, this.log);
    }

    protected Properties createRoles(Map<String, ?> options) throws IOException {
        this.loadRoles();
        return this.roles;
    }

    protected void parseGroupMembers(Group group, String roles) {
        Util.parseGroupMembers(group, roles, this);
    }
}

