/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.schema;

import java.util.Optional;
import org.javers.repository.sql.SqlRepositoryConfiguration;
import org.javers.repository.sql.schema.DBObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableNameProvider {
    private static final String SNAPSHOT_TABLE_PK_SEQ = "jv_snapshot_pk_seq";
    private static final String COMMIT_PK_SEQ = "jv_commit_pk_seq";
    private static final String GLOBAL_ID_PK_SEQ = "jv_global_id_pk_seq";
    private static final String DEFAULT_GLOBAL_ID_TABLE_NAME = "jv_global_id";
    private static final String DEFAULT_SNAPSHOT_TABLE_NAME = "jv_snapshot";
    private static final String DEFAULT_COMMIT_TABLE_NAME = "jv_commit";
    private static final String DEFAULT_COMMIT_PROPERTY_TABLE_NAME = "jv_commit_property";
    private static final Logger logger = LoggerFactory.getLogger(TableNameProvider.class);
    private final SqlRepositoryConfiguration configuration;

    public TableNameProvider(SqlRepositoryConfiguration configuration) {
        this.configuration = configuration;
        logger.info("Commit table:           {}", (Object)this.getCommitTableNameWithSchema());
        logger.info("CommitProperty table:   {}", (Object)this.getCommitPropertyTableNameWithSchema());
        logger.info("GlobalId table:         {}", (Object)this.getGlobalIdTableNameWithSchema());
        logger.info("Snapshot table:         {}", (Object)this.getSnapshotTableNameWithSchema());
    }

    public String getGlobalIdTableNameWithSchema() {
        return this.getGlobalIdTableName().nameWithSchema();
    }

    public String getCommitTableNameWithSchema() {
        return this.getCommitTableName().nameWithSchema();
    }

    public String getCommitPropertyTableNameWithSchema() {
        return this.getCommitPropertyTableName().nameWithSchema();
    }

    public String getSnapshotTableNameWithSchema() {
        return this.getSnapshotTableName().nameWithSchema();
    }

    public DBObjectName getSnapshotTablePkSeqName() {
        return this.fullDbName(SNAPSHOT_TABLE_PK_SEQ);
    }

    public DBObjectName getGlobalIdPkSeqName() {
        return this.fullDbName(GLOBAL_ID_PK_SEQ);
    }

    public DBObjectName getCommitPkSeqName() {
        return this.fullDbName(COMMIT_PK_SEQ);
    }

    @Deprecated
    public String getCdoClassTableNameWithSchema() {
        return this.fullDbName("jv_cdo_class").nameWithSchema();
    }

    DBObjectName getGlobalIdTableName() {
        return this.fullDbName(this.configuration.getGlobalIdTableName().orElse(DEFAULT_GLOBAL_ID_TABLE_NAME));
    }

    DBObjectName getCommitTableName() {
        return this.fullDbName(this.configuration.getCommitTableName().orElse(DEFAULT_COMMIT_TABLE_NAME));
    }

    DBObjectName getCommitPropertyTableName() {
        return this.fullDbName(this.configuration.getCommitPropertyTableName().orElse(DEFAULT_COMMIT_PROPERTY_TABLE_NAME));
    }

    DBObjectName getSnapshotTableName() {
        return this.fullDbName(this.configuration.getSnapshotTableName().orElse(DEFAULT_SNAPSHOT_TABLE_NAME));
    }

    Optional<String> getSchemaName() {
        return this.configuration.getSchemaNameAsOptional();
    }

    private DBObjectName fullDbName(String name) {
        return new DBObjectName(this.configuration.getSchemaNameAsOptional(), name);
    }
}

