/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jasig.services.persondir.support.IUsernameAttributeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleUsernameAttributeProvider
implements IUsernameAttributeProvider {
    private String usernameAttribute = "username";

    public SimpleUsernameAttributeProvider() {
    }

    public SimpleUsernameAttributeProvider(String usernameAttribute) {
        this.setUsernameAttribute(usernameAttribute);
    }

    public void setUsernameAttribute(String usernameAttribute) {
        Validate.notNull((Object)usernameAttribute);
        this.usernameAttribute = usernameAttribute;
    }

    @Override
    public String getUsernameAttribute() {
        return this.usernameAttribute;
    }

    @Override
    public String getUsernameFromQuery(Map<String, List<Object>> query) {
        List<Object> usernameAttributeValues = query.get(this.usernameAttribute);
        if (usernameAttributeValues == null || usernameAttributeValues.size() == 0) {
            return null;
        }
        Object firstValue = usernameAttributeValues.get(0);
        if (firstValue == null) {
            return null;
        }
        String username = StringUtils.trimToNull((String)String.valueOf(firstValue));
        if (username == null || username.contains("*")) {
            return null;
        }
        return username;
    }
}

