/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.springframework.dao.support.DataAccessUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasePersonAttributeDao
implements IPersonAttributeDao {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public final Map<String, List<Object>> getMultivaluedUserAttributes(Map<String, List<Object>> seed) {
        Set people = this.getPeopleWithMultivaluedAttributes(seed);
        IPersonAttributes person = (IPersonAttributes)DataAccessUtils.singleResult((Collection)people);
        if (person == null) {
            return null;
        }
        return new LinkedHashMap<String, List<Object>>(person.getAttributes());
    }

    public final Map<String, List<Object>> getMultivaluedUserAttributes(String uid) {
        IPersonAttributes person = this.getPerson(uid);
        if (person == null) {
            return null;
        }
        return new LinkedHashMap<String, List<Object>>(person.getAttributes());
    }

    public final Map<String, Object> getUserAttributes(Map<String, Object> seed) {
        Set people = this.getPeople(seed);
        IPersonAttributes person = (IPersonAttributes)DataAccessUtils.singleResult((Collection)people);
        if (person == null) {
            return null;
        }
        LinkedHashMap<String, List<Object>> multivaluedUserAttributes = new LinkedHashMap<String, List<Object>>(person.getAttributes());
        return this.flattenResults(multivaluedUserAttributes);
    }

    public final Map<String, Object> getUserAttributes(String uid) {
        Validate.notNull((Object)uid, (String)"uid may not be null.");
        Map<String, List<Object>> multivaluedUserAttributes = this.getMultivaluedUserAttributes(uid);
        return this.flattenResults(multivaluedUserAttributes);
    }

    @Deprecated
    protected Map<String, Object> flattenResults(Map<String, List<Object>> multivaluedUserAttributes) {
        if (multivaluedUserAttributes == null) {
            return null;
        }
        LinkedHashMap<String, Object> userAttributes = new LinkedHashMap<String, Object>(multivaluedUserAttributes.size());
        for (Map.Entry<String, List<Object>> attrEntry : multivaluedUserAttributes.entrySet()) {
            String attrName = attrEntry.getKey();
            List<Object> attrValues = attrEntry.getValue();
            Object value = attrValues == null || attrValues.size() == 0 ? null : attrValues.get(0);
            userAttributes.put(attrName, value);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Flattened Map='" + multivaluedUserAttributes + "' into Map='" + userAttributes + "'"));
        }
        return userAttributes;
    }
}

