/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.configuration.PlexusConfiguration;

class MutablePlexusConfiguration
implements PlexusConfiguration {
    private static final PlexusConfiguration[] NO_CHILDREN = new PlexusConfiguration[0];
    private final String name;
    private String value;
    private List<PlexusConfiguration> childIndex = Collections.emptyList();
    private Map<String, List<PlexusConfiguration>> childMap = Collections.emptyMap();
    private Map<String, String> attributeMap = Collections.emptyMap();

    public MutablePlexusConfiguration(PlexusConfiguration source) {
        this.name = source.getName();
        this.value = source.getValue();
        for (String string : source.getAttributeNames()) {
            this.setAttribute(string, source.getAttribute(string));
        }
        for (String string : source.getChildren()) {
            this.addChild((PlexusConfiguration)string);
        }
    }

    public MutablePlexusConfiguration(String name) {
        this(name, null);
    }

    public MutablePlexusConfiguration(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public final String getName() {
        return this.name;
    }

    public final String getValue() {
        return this.value;
    }

    public final String getValue(String defaultValue) {
        return null != this.value ? this.value : defaultValue;
    }

    public final void setValue(String value) {
        this.value = value;
    }

    public final String[] getAttributeNames() {
        return this.attributeMap.keySet().toArray(new String[this.attributeMap.size()]);
    }

    public final String getAttribute(String attributeName) {
        return this.attributeMap.get(attributeName);
    }

    public final String getAttribute(String attributeName, String defaultValue) {
        String attributeValue = this.attributeMap.get(attributeName);
        return null != attributeValue ? attributeValue : defaultValue;
    }

    public final void setAttribute(String attributeName, String attributeValue) {
        if (this.attributeMap.isEmpty()) {
            this.attributeMap = new HashMap<String, String>();
        }
        this.attributeMap.put(attributeName, attributeValue);
    }

    public final PlexusConfiguration getChild(String childName) {
        return this.getChild(childName, true);
    }

    public final void replaceLastChild(PlexusConfiguration newChild) {
        String childName = newChild.getName();
        List<PlexusConfiguration> children = this.childMap.get(childName);
        if (null == children) {
            this.addChild(newChild);
        }
        children.set(children.size() - 1, newChild);
    }

    public final PlexusConfiguration getChild(String childName, boolean create) {
        List<PlexusConfiguration> children = this.childMap.get(childName);
        if (null != children) {
            return children.get(0);
        }
        return create ? this.add(this.createChild(childName)) : null;
    }

    public final PlexusConfiguration[] getChildren() {
        return this.childIndex.toArray(new PlexusConfiguration[this.childIndex.size()]);
    }

    public final PlexusConfiguration[] getChildren(String childName) {
        List<PlexusConfiguration> children = this.childMap.get(childName);
        if (null != children) {
            return children.toArray(new PlexusConfiguration[children.size()]);
        }
        return NO_CHILDREN;
    }

    public final int getChildCount() {
        return this.childIndex.size();
    }

    public final PlexusConfiguration getChild(int index) {
        return this.childIndex.get(index);
    }

    public final void addChild(PlexusConfiguration child) {
        this.add(child);
    }

    public final PlexusConfiguration addChild(String childName, String childValue) {
        this.add(this.createChild(childName)).setValue(childValue);
        return this;
    }

    protected PlexusConfiguration createChild(String childName) {
        return new MutablePlexusConfiguration(childName);
    }

    protected final PlexusConfiguration add(PlexusConfiguration child) {
        String childName = child.getName();
        List<PlexusConfiguration> children = this.childMap.get(childName);
        if (null == children) {
            children = new ArrayList<PlexusConfiguration>();
            if (this.childMap.isEmpty()) {
                this.childMap = new LinkedHashMap<String, List<PlexusConfiguration>>();
                this.childIndex = new ArrayList<PlexusConfiguration>();
            }
            this.childMap.put(childName, children);
        }
        this.childIndex.add(child);
        children.add(child);
        return child;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append('<').append(this.getName());
        for (String string : this.getAttributeNames()) {
            buf.append(' ').append(string).append("=\"").append(this.getAttribute(string)).append('\"');
        }
        if (this.getChildCount() > 0) {
            buf.append('>');
            for (String string : this.getChildren()) {
                buf.append((Object)string);
            }
            buf.append("</").append(this.getName()).append('>');
        } else if (null != this.getValue()) {
            buf.append('>').append(this.getValue()).append("</").append(this.getName()).append('>');
        } else {
            buf.append("/>");
        }
        return buf.append('\n').toString();
    }
}

