/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.serialization;

import java.util.function.Consumer;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.RespErrorUtil;
import org.infinispan.server.resp.serialization.Resp3Response;
import org.infinispan.server.resp.serialization.ResponseSerializer;

final class ThrowableSerializer
implements ResponseSerializer<Throwable> {
    static final ThrowableSerializer INSTANCE = new ThrowableSerializer();
    private static final String DEFAULT_ERROR_MESSAGE = "failed handling command";

    ThrowableSerializer() {
    }

    @Override
    public void accept(Throwable throwable, ByteBufPool alloc) {
        Consumer<ByteBufPool> writer = RespErrorUtil.handleException(throwable);
        if (writer != null) {
            writer.accept(alloc);
        } else {
            Resp3Response.error("-ERR " + this.extractRootCauseMessage(throwable), alloc);
        }
    }

    private String extractRootCauseMessage(Throwable t) {
        Throwable r;
        for (r = t; r != null && r.getCause() != null; r = r.getCause()) {
        }
        return r == null ? DEFAULT_ERROR_MESSAGE : r.getMessage();
    }

    @Override
    public boolean test(Object object) {
        return object instanceof Throwable;
    }
}

