/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.filter;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.filter.AbstractKeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.metadata.Metadata;
import org.infinispan.server.resp.ExternalizerIds;

public class ComposedFilterConverter<K, V, C>
extends AbstractKeyValueFilterConverter<K, V, C> {
    public static final AdvancedExternalizer<ComposedFilterConverter> EXTERNALIZER = new Externalizer();
    final List<KeyValueFilterConverter<K, V, C>> filterConverters;

    public ComposedFilterConverter(List<KeyValueFilterConverter<K, V, C>> filterConverters) {
        this.filterConverters = filterConverters;
    }

    public C filterAndConvert(K key, V value, Metadata metadata) {
        KeyValueFilterConverter<K, V, C> fc;
        Object ret = null;
        Iterator<KeyValueFilterConverter<K, V, C>> iterator = this.filterConverters.iterator();
        while (iterator.hasNext() && (ret = (fc = iterator.next()).filterAndConvert(key, value, metadata)) != null) {
        }
        return (C)ret;
    }

    public MediaType format() {
        return null;
    }

    private static class Externalizer
    extends AbstractExternalizer<ComposedFilterConverter> {
        private Externalizer() {
        }

        public Integer getId() {
            return ExternalizerIds.COMPOSED_FILTER_CONVERTER;
        }

        public Set<Class<? extends ComposedFilterConverter>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{ComposedFilterConverter.class});
        }

        public void writeObject(ObjectOutput output, ComposedFilterConverter object) throws IOException {
            MarshallUtil.marshallCollection(object.filterConverters, (ObjectOutput)output);
        }

        public ComposedFilterConverter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            List filters = (List)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
            return new ComposedFilterConverter(filters);
        }
    }
}

