/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.printers;

import java.io.IOException;
import java.util.Map;
import org.aesh.command.shell.Shell;
import org.infinispan.cli.printers.AbstractPrettyPrinter;

public class JsonPrettyPrinter
extends AbstractPrettyPrinter {
    private boolean commaRow;

    protected JsonPrettyPrinter(Shell shell) {
        super(shell);
        shell.writeln("[");
    }

    @Override
    public void printItem(Map<String, String> item) {
        boolean simple;
        if (this.commaRow) {
            this.shell.writeln(",");
        } else {
            this.commaRow = true;
        }
        boolean bl = simple = item.size() == 1;
        if (!simple) {
            this.shell.write("{");
        }
        boolean commaCol = false;
        for (Map.Entry<String, String> column : item.entrySet()) {
            if (commaCol) {
                this.shell.writeln(", ");
            } else {
                commaCol = true;
            }
            if (!simple) {
                this.shell.write(column.getKey());
                this.shell.write(": ");
            }
            this.shell.write('\"');
            this.shell.write(column.getValue());
            this.shell.write('\"');
        }
        if (!simple) {
            this.shell.write("}");
        }
    }

    @Override
    public void close() throws IOException {
        this.shell.writeln("");
        this.shell.writeln("]");
    }
}

