//=============================================
// J A V A  C O M M U N I T Y  P R O C E S S
// 
// J S R  3 3 1
// 
// Common Implementation
// 
//============================================= 
package javax.constraints.impl.search.goal;


import javax.constraints.Problem;
import javax.constraints.Solution;
import javax.constraints.Var;

/**
 * This goal is trying to resolve the problem using a solution
 * passed as a parameter.
 */
public class GoalApplySolution extends Goal {

	Solution solution;

	public GoalApplySolution(Solution solution) {
		super(solution.getSolver(), "ApplySolution");
		this.solution = solution;
	}

	/**
	 * Adds a solution to the array of the current problem solutions.
	 * Increases the total number of solutions. If it has reaches
	 *  getMaxNumberOfSolutions() then after adding the solution the goal fails.
	 */
	public Goal execute() throws Exception {
		Problem p = getProblem();
		trace();
		Var[] problemVars = p.getVars();
		for(int i=0; i < solution.getNumberOfVars(); i++) {
			p.post(problemVars[i], ">=", solution.getMin(i));
//			problemVars[i].ge(solutionVars[i].getMin()).post(); 
			p.post(problemVars[i], "<=", solution.getMax(i));
//			problemVars[i].le(solutionVars[i].getMax()).post();
		}
		return null;
	}
}
