/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.impl;

import java.util.function.Function;
import org.hibernate.search.util.common.impl.ClosingOperator;

public abstract class AbstractCloser<S, E extends Exception> {
    public <T> S push(ClosingOperator<T, ? extends E> operator, T objectToClose) {
        return this.push(operator, objectToClose, Function.identity());
    }

    public <T, U> S push(ClosingOperator<T, ? extends E> operator, U objectToExtractFrom, Function<U, T> extract) {
        try {
            Object objectToClose;
            Object t = objectToClose = objectToExtractFrom == null ? null : (Object)extract.apply(objectToExtractFrom);
            if (objectToClose != null) {
                operator.close(objectToClose);
            }
        }
        catch (Throwable t) {
            this.getState().addThrowable(this, t);
        }
        return this.getSelf();
    }

    public <T> S pushAll(ClosingOperator<T, ? extends E> operator, Iterable<T> objectsToClose) {
        return this.pushAll(operator, objectsToClose, Function.identity());
    }

    public <T, U> S pushAll(ClosingOperator<T, ? extends E> operator, Iterable<? extends U> objectsToExtractFrom, Function<U, T> extract) {
        for (U objectToExtractFrom : objectsToExtractFrom) {
            this.push(operator, objectToExtractFrom, extract);
        }
        return this.getSelf();
    }

    @SafeVarargs
    public final <T> S pushAll(ClosingOperator<T, ? extends E> operator, T ... objectsToClose) {
        for (T objectToClose : objectsToClose) {
            this.push(operator, objectToClose);
        }
        return this.getSelf();
    }

    abstract S getSelf();

    abstract State getState();

    static class State {
        AbstractCloser<?, ?> firstThrower;
        Throwable firstThrowable;

        State() {
        }

        void addThrowable(AbstractCloser<?, ?> source, Throwable throwable) {
            if (this.firstThrowable == null) {
                this.firstThrowable = throwable;
                this.firstThrower = source;
            } else {
                this.firstThrowable.addSuppressed(throwable);
            }
        }
    }
}

