/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl;

import java.util.Map;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.RoutingBinder;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.TypeMappingIndexedStep;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.spi.PojoAdditionalMetadataCollectorIndexedTypeNode;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.spi.PojoAdditionalMetadataCollectorTypeNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;

class TypeMappingIndexedStepImpl
implements TypeMappingIndexedStep,
PojoTypeMetadataContributor {
    private final PojoRawTypeIdentifier<?> typeIdentifier;
    private String backendName;
    private String indexName;
    private Boolean enabled;
    private RoutingBinder binder;
    private Map<String, Object> params;

    TypeMappingIndexedStepImpl(PojoRawTypeIdentifier<?> typeIdentifier) {
        this.typeIdentifier = typeIdentifier;
    }

    @Override
    public TypeMappingIndexedStep backend(String backendName) {
        this.backendName = backendName;
        return this;
    }

    @Override
    public TypeMappingIndexedStep index(String indexName) {
        this.indexName = indexName;
        return this;
    }

    @Override
    public TypeMappingIndexedStep enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public TypeMappingIndexedStep routingBinder(RoutingBinder binder, Map<String, Object> params) {
        this.binder = binder;
        this.params = params;
        return this;
    }

    @Override
    public void contributeAdditionalMetadata(PojoAdditionalMetadataCollectorTypeNode collector) {
        PojoAdditionalMetadataCollectorIndexedTypeNode indexedCollector = collector.markAsIndexed();
        if (this.enabled != null) {
            indexedCollector.enabled(this.enabled);
        }
        if (this.backendName != null) {
            indexedCollector.backendName(this.backendName);
        }
        if (this.binder != null) {
            indexedCollector.routingBinder(this.binder, this.params);
        }
        if (this.typeIdentifier.equals(collector.typeIdentifier()) && this.indexName != null) {
            indexedCollector.indexName(this.indexName);
        }
    }
}

