/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.impl;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.mapper.pojo.logging.impl.MappingLog;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.ConstructorMapping;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.ConstructorMappingAnnotationProcessor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.ConstructorMappingAnnotationProcessorRef;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.MethodParameterMapping;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.MethodParameterMappingAnnotationProcessor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.MethodParameterMappingAnnotationProcessorRef;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.PropertyMapping;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.PropertyMappingAnnotationProcessor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.PropertyMappingAnnotationProcessorRef;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.TypeMapping;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.TypeMappingAnnotationProcessor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.TypeMappingAnnotationProcessorRef;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.spi.MappingAnnotationProcessorUtils;
import org.hibernate.search.mapper.pojo.reporting.spi.PojoEventContexts;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.reflect.impl.GenericTypeContext;
import org.hibernate.search.util.common.reflect.impl.ReflectionUtils;

public class AnnotationProcessorProvider {
    private final BeanResolver beanResolver;
    private final FailureCollector rootFailureCollector;
    private final Map<Class<? extends Annotation>, Optional<BeanReference<? extends TypeMappingAnnotationProcessor>>> typeAnnotationProcessorReferenceCache = new HashMap<Class<? extends Annotation>, Optional<BeanReference<? extends TypeMappingAnnotationProcessor>>>();
    private final Map<Class<? extends Annotation>, Optional<BeanReference<? extends ConstructorMappingAnnotationProcessor>>> constructorAnnotationProcessorReferenceCache = new HashMap<Class<? extends Annotation>, Optional<BeanReference<? extends ConstructorMappingAnnotationProcessor>>>();
    private final Map<Class<? extends Annotation>, Optional<BeanReference<? extends MethodParameterMappingAnnotationProcessor>>> methodParameterAnnotationProcessorReferenceCache = new HashMap<Class<? extends Annotation>, Optional<BeanReference<? extends MethodParameterMappingAnnotationProcessor>>>();
    private final Map<Class<? extends Annotation>, Optional<BeanReference<? extends PropertyMappingAnnotationProcessor>>> propertyAnnotationProcessorReferenceCache = new HashMap<Class<? extends Annotation>, Optional<BeanReference<? extends PropertyMappingAnnotationProcessor>>>();

    public AnnotationProcessorProvider(BeanResolver beanResolver, FailureCollector rootFailureCollector) {
        this.beanResolver = beanResolver;
        this.rootFailureCollector = rootFailureCollector;
    }

    public <A extends Annotation> Optional<BeanHolder<? extends TypeMappingAnnotationProcessor<? super A>>> createTypeAnnotationProcessor(A annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        BeanHolder<? extends TypeMappingAnnotationProcessor> processor = null;
        try {
            Optional<BeanReference<? extends TypeMappingAnnotationProcessor>> processorReference = this.getTypeAnnotationProcessorReference(annotationType);
            if (!processorReference.isPresent()) {
                return Optional.empty();
            }
            processor = this.createProcessorBean(TypeMappingAnnotationProcessor.class, annotationType, processorReference.get());
        }
        catch (RuntimeException e) {
            this.rootFailureCollector.withContext(PojoEventContexts.fromAnnotationType(annotationType)).add((Throwable)e);
            this.typeAnnotationProcessorReferenceCache.put(annotationType, Optional.empty());
        }
        return Optional.ofNullable(processor);
    }

    public <A extends Annotation> Optional<BeanHolder<? extends ConstructorMappingAnnotationProcessor<? super A>>> createConstructorAnnotationProcessor(A annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        BeanHolder<? extends ConstructorMappingAnnotationProcessor> processor = null;
        try {
            Optional<BeanReference<? extends ConstructorMappingAnnotationProcessor>> processorReference = this.getConstructorAnnotationProcessorReference(annotationType);
            if (!processorReference.isPresent()) {
                return Optional.empty();
            }
            processor = this.createProcessorBean(ConstructorMappingAnnotationProcessor.class, annotationType, processorReference.get());
        }
        catch (RuntimeException e) {
            this.rootFailureCollector.withContext(PojoEventContexts.fromAnnotationType(annotationType)).add((Throwable)e);
            this.typeAnnotationProcessorReferenceCache.put(annotationType, Optional.empty());
        }
        return Optional.ofNullable(processor);
    }

    public <A extends Annotation> Optional<BeanHolder<? extends MethodParameterMappingAnnotationProcessor<? super A>>> createMethodParameterAnnotationProcessor(A annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        BeanHolder<? extends MethodParameterMappingAnnotationProcessor> processor = null;
        try {
            Optional<BeanReference<? extends MethodParameterMappingAnnotationProcessor>> processorReference = this.getMethodParameterAnnotationProcessorReference(annotationType);
            if (!processorReference.isPresent()) {
                return Optional.empty();
            }
            processor = this.createProcessorBean(MethodParameterMappingAnnotationProcessor.class, annotationType, processorReference.get());
        }
        catch (RuntimeException e) {
            this.rootFailureCollector.withContext(PojoEventContexts.fromAnnotationType(annotationType)).add((Throwable)e);
            this.typeAnnotationProcessorReferenceCache.put(annotationType, Optional.empty());
        }
        return Optional.ofNullable(processor);
    }

    public <A extends Annotation> Optional<BeanHolder<? extends PropertyMappingAnnotationProcessor<? super A>>> createPropertyAnnotationProcessor(A annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        BeanHolder<? extends PropertyMappingAnnotationProcessor> processor = null;
        try {
            Optional<BeanReference<? extends PropertyMappingAnnotationProcessor>> processorReference = this.getPropertyAnnotationProcessorReference(annotationType);
            if (!processorReference.isPresent()) {
                return Optional.empty();
            }
            processor = this.createProcessorBean(PropertyMappingAnnotationProcessor.class, annotationType, processorReference.get());
        }
        catch (RuntimeException e) {
            this.rootFailureCollector.withContext(PojoEventContexts.fromAnnotationType(annotationType)).add((Throwable)e);
            this.typeAnnotationProcessorReferenceCache.put(annotationType, Optional.empty());
        }
        return Optional.ofNullable(processor);
    }

    private Optional<BeanReference<? extends TypeMappingAnnotationProcessor>> getTypeAnnotationProcessorReference(Class<? extends Annotation> annotationType) {
        Optional<BeanReference<? extends TypeMappingAnnotationProcessor>> processorReference = this.typeAnnotationProcessorReferenceCache.get(annotationType);
        if (processorReference == null) {
            processorReference = this.createTypeAnnotationProcessorReference(annotationType);
            this.typeAnnotationProcessorReferenceCache.put(annotationType, processorReference);
        }
        return processorReference;
    }

    private Optional<BeanReference<? extends ConstructorMappingAnnotationProcessor>> getConstructorAnnotationProcessorReference(Class<? extends Annotation> annotationType) {
        Optional<BeanReference<? extends ConstructorMappingAnnotationProcessor>> processorReference = this.constructorAnnotationProcessorReferenceCache.get(annotationType);
        if (processorReference == null) {
            processorReference = this.createConstructorAnnotationProcessorReference(annotationType);
            this.constructorAnnotationProcessorReferenceCache.put(annotationType, processorReference);
        }
        return processorReference;
    }

    private Optional<BeanReference<? extends MethodParameterMappingAnnotationProcessor>> getMethodParameterAnnotationProcessorReference(Class<? extends Annotation> annotationType) {
        Optional<BeanReference<? extends MethodParameterMappingAnnotationProcessor>> processorReference = this.methodParameterAnnotationProcessorReferenceCache.get(annotationType);
        if (processorReference == null) {
            processorReference = this.createMethodParameterAnnotationProcessorReference(annotationType);
            this.methodParameterAnnotationProcessorReferenceCache.put(annotationType, processorReference);
        }
        return processorReference;
    }

    private Optional<BeanReference<? extends PropertyMappingAnnotationProcessor>> getPropertyAnnotationProcessorReference(Class<? extends Annotation> annotationType) {
        Optional<BeanReference<? extends PropertyMappingAnnotationProcessor>> processorReference = this.propertyAnnotationProcessorReferenceCache.get(annotationType);
        if (processorReference == null) {
            processorReference = this.createPropertyAnnotationProcessorReference(annotationType);
            this.propertyAnnotationProcessorReferenceCache.put(annotationType, processorReference);
        }
        return processorReference;
    }

    private Optional<BeanReference<? extends TypeMappingAnnotationProcessor>> createTypeAnnotationProcessorReference(Class<? extends Annotation> annotationType) {
        TypeMapping mapping = annotationType.getAnnotation(TypeMapping.class);
        if (mapping == null) {
            return Optional.empty();
        }
        TypeMappingAnnotationProcessorRef referenceAnnotation = mapping.processor();
        Optional<BeanReference<? extends TypeMappingAnnotationProcessor>> processorReference = MappingAnnotationProcessorUtils.toBeanReference(TypeMappingAnnotationProcessor.class, TypeMappingAnnotationProcessorRef.UndefinedProcessorImplementationType.class, referenceAnnotation.type(), referenceAnnotation.name(), referenceAnnotation.retrieval());
        if (!processorReference.isPresent()) {
            throw MappingLog.INSTANCE.missingProcessorReferenceInMappingAnnotation(TypeMapping.class);
        }
        return processorReference;
    }

    private <A extends Annotation> Optional<BeanReference<? extends ConstructorMappingAnnotationProcessor>> createConstructorAnnotationProcessorReference(Class<? extends A> annotationType) {
        ConstructorMapping mapping = annotationType.getAnnotation(ConstructorMapping.class);
        if (mapping == null) {
            return Optional.empty();
        }
        ConstructorMappingAnnotationProcessorRef referenceAnnotation = mapping.processor();
        Optional<BeanReference<? extends ConstructorMappingAnnotationProcessor>> processorReference = MappingAnnotationProcessorUtils.toBeanReference(ConstructorMappingAnnotationProcessor.class, ConstructorMappingAnnotationProcessorRef.UndefinedProcessorImplementationType.class, referenceAnnotation.type(), referenceAnnotation.name(), referenceAnnotation.retrieval());
        if (!processorReference.isPresent()) {
            throw MappingLog.INSTANCE.missingProcessorReferenceInMappingAnnotation(ConstructorMapping.class);
        }
        return processorReference;
    }

    private <A extends Annotation> Optional<BeanReference<? extends MethodParameterMappingAnnotationProcessor>> createMethodParameterAnnotationProcessorReference(Class<? extends A> annotationType) {
        MethodParameterMapping mapping = annotationType.getAnnotation(MethodParameterMapping.class);
        if (mapping == null) {
            return Optional.empty();
        }
        MethodParameterMappingAnnotationProcessorRef referenceAnnotation = mapping.processor();
        Optional<BeanReference<? extends MethodParameterMappingAnnotationProcessor>> processorReference = MappingAnnotationProcessorUtils.toBeanReference(MethodParameterMappingAnnotationProcessor.class, MethodParameterMappingAnnotationProcessorRef.UndefinedProcessorImplementationType.class, referenceAnnotation.type(), referenceAnnotation.name(), referenceAnnotation.retrieval());
        if (!processorReference.isPresent()) {
            throw MappingLog.INSTANCE.missingProcessorReferenceInMappingAnnotation(MethodParameterMapping.class);
        }
        return processorReference;
    }

    private <A extends Annotation> Optional<BeanReference<? extends PropertyMappingAnnotationProcessor>> createPropertyAnnotationProcessorReference(Class<? extends A> annotationType) {
        PropertyMapping mapping = annotationType.getAnnotation(PropertyMapping.class);
        if (mapping == null) {
            return Optional.empty();
        }
        PropertyMappingAnnotationProcessorRef referenceAnnotation = mapping.processor();
        Optional<BeanReference<? extends PropertyMappingAnnotationProcessor>> processorReference = MappingAnnotationProcessorUtils.toBeanReference(PropertyMappingAnnotationProcessor.class, PropertyMappingAnnotationProcessorRef.UndefinedProcessorImplementationType.class, referenceAnnotation.type(), referenceAnnotation.name(), referenceAnnotation.retrieval());
        if (!processorReference.isPresent()) {
            throw MappingLog.INSTANCE.missingProcessorReferenceInMappingAnnotation(PropertyMapping.class);
        }
        return processorReference;
    }

    private <B, A extends Annotation> BeanHolder<? extends B> createProcessorBean(Class<B> expectedType, Class<A> encounteredAnnotationType, BeanReference<? extends B> processorReference) {
        BeanHolder delegateHolder = processorReference.resolve(this.beanResolver);
        try {
            Object processor = delegateHolder.get();
            GenericTypeContext bridgeTypeContext = new GenericTypeContext(processor.getClass());
            Class processorAnnotationType = bridgeTypeContext.resolveTypeArgument(expectedType, 0).map(ReflectionUtils::getRawType).orElseThrow(() -> new AssertionFailure("Could not auto-detect the annotation type accepted by processor '" + String.valueOf(processor) + "'."));
            if (!processorAnnotationType.isAssignableFrom(encounteredAnnotationType)) {
                throw MappingLog.INSTANCE.invalidAnnotationTypeForAnnotationProcessor(processor, processorAnnotationType);
            }
            return delegateHolder;
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push((AutoCloseable)delegateHolder);
            throw e;
        }
    }
}

