/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.reader.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.hibernate.search.backend.lucene.logging.impl.LuceneMiscLog;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.DirectoryReaderCollector;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderMetadataResolver;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.ReadIndexManagerContext;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;

public class HibernateSearchMultiReader
extends MultiReader {
    private final List<DirectoryReader> directoryReaders;
    private final IndexReaderMetadataResolver metadataResolver;

    public static HibernateSearchMultiReader open(Set<String> indexNames, Collection<? extends ReadIndexManagerContext> indexManagerContexts, Set<String> routingKeys) {
        if (indexManagerContexts.isEmpty()) {
            return null;
        }
        Builder builder = new Builder();
        try {
            for (ReadIndexManagerContext readIndexManagerContext : indexManagerContexts) {
                readIndexManagerContext.openIndexReaders(routingKeys, builder);
            }
            return builder.build();
        }
        catch (IOException | RuntimeException e) {
            new SuppressingCloser((Throwable)e).pushAll(builder.directoryReaders);
            throw LuceneMiscLog.INSTANCE.unableToOpenIndexReaders(e.getMessage(), EventContexts.fromIndexNames(indexNames), e);
        }
    }

    HibernateSearchMultiReader(List<DirectoryReader> directoryReaders, IndexReaderMetadataResolver metadataResolver) throws IOException {
        super(HibernateSearchMultiReader.toReaderArray(directoryReaders), true);
        this.directoryReaders = directoryReaders;
        this.metadataResolver = metadataResolver;
    }

    public IndexReaderMetadataResolver getMetadataResolver() {
        return this.metadataResolver;
    }

    protected synchronized void doClose() throws IOException {
        boolean traceEnabled = LuceneMiscLog.INSTANCE.isTraceEnabled();
        if (traceEnabled) {
            LuceneMiscLog.INSTANCE.closingMultiReader(this);
        }
        try (Closer closer = new Closer();){
            closer.pushAll(IndexReader::decRef, this.directoryReaders);
        }
        if (traceEnabled) {
            LuceneMiscLog.INSTANCE.closedMultiReader(this);
        }
    }

    private static IndexReader[] toReaderArray(List<DirectoryReader> directoryReaders) {
        return (IndexReader[])directoryReaders.toArray(new DirectoryReader[0]);
    }

    public static class Builder
    implements DirectoryReaderCollector {
        private final List<DirectoryReader> directoryReaders = new ArrayList<DirectoryReader>();
        private final Map<DirectoryReader, String> mappedTypeNameByDirectoryReader = new HashMap<DirectoryReader, String>();

        private Builder() {
        }

        @Override
        public void collect(String mappedTypeName, DirectoryReader directoryReader) {
            this.directoryReaders.add(directoryReader);
            this.mappedTypeNameByDirectoryReader.put(directoryReader, mappedTypeName);
        }

        HibernateSearchMultiReader build() throws IOException {
            IndexReaderMetadataResolver metadataResolver = new IndexReaderMetadataResolver(this.mappedTypeNameByDirectoryReader);
            return new HibernateSearchMultiReader(this.directoryReaders, metadataResolver);
        }
    }
}

