/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.xml;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.Payload;
import javax.validation.ValidationException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.hibernate.validator.metadata.AnnotationIgnores;
import org.hibernate.validator.metadata.ConstraintDescriptorImpl;
import org.hibernate.validator.metadata.ConstraintHelper;
import org.hibernate.validator.metadata.ConstraintOrigin;
import org.hibernate.validator.metadata.MetaConstraint;
import org.hibernate.validator.util.ContainsField;
import org.hibernate.validator.util.ContainsMethod;
import org.hibernate.validator.util.GetClassLoader;
import org.hibernate.validator.util.GetDeclaredField;
import org.hibernate.validator.util.GetMethod;
import org.hibernate.validator.util.GetMethodFromPropertyName;
import org.hibernate.validator.util.LoadClass;
import org.hibernate.validator.util.LoggerFactory;
import org.hibernate.validator.util.annotationfactory.AnnotationDescriptor;
import org.hibernate.validator.util.annotationfactory.AnnotationFactory;
import org.hibernate.validator.xml.AnnotationType;
import org.hibernate.validator.xml.BeanType;
import org.hibernate.validator.xml.ClassType;
import org.hibernate.validator.xml.ConstraintDefinitionType;
import org.hibernate.validator.xml.ConstraintMappingsType;
import org.hibernate.validator.xml.ConstraintType;
import org.hibernate.validator.xml.ElementType;
import org.hibernate.validator.xml.FieldType;
import org.hibernate.validator.xml.GetterType;
import org.hibernate.validator.xml.GroupSequenceType;
import org.hibernate.validator.xml.GroupsType;
import org.hibernate.validator.xml.PayloadType;
import org.hibernate.validator.xml.ValidatedByType;
import org.slf4j.Logger;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlMappingParser {
    private static final Logger log = LoggerFactory.make();
    private static final String VALIDATION_MAPPING_XSD = "META-INF/validation-mapping-1.0.xsd";
    private static final String MESSAGE_PARAM = "message";
    private static final String GROUPS_PARAM = "groups";
    private static final String PAYLOAD_PARAM = "payload";
    private static final String PACKAGE_SEPARATOR = ".";
    private final Set<Class<?>> processedClasses = new HashSet();
    private final ConstraintHelper constraintHelper;
    private final AnnotationIgnores annotationIgnores;
    private final Map<Class<?>, List<MetaConstraint<?, ? extends Annotation>>> constraintMap;
    private final Map<Class<?>, List<Member>> cascadedMembers;
    private final Map<Class<?>, List<Class<?>>> defaultSequences;

    public XmlMappingParser(ConstraintHelper constraintHelper) {
        this.constraintHelper = constraintHelper;
        this.annotationIgnores = new AnnotationIgnores();
        this.constraintMap = new HashMap();
        this.cascadedMembers = new HashMap();
        this.defaultSequences = new HashMap();
    }

    public void parse(Set<InputStream> mappingStreams) {
        for (InputStream in : mappingStreams) {
            ConstraintMappingsType mapping = this.getValidationConfig(in);
            String defaultPackage = mapping.getDefaultPackage();
            this.parseConstraintDefinitions(mapping.getConstraintDefinition(), defaultPackage);
            for (BeanType bean : mapping.getBean()) {
                Class<?> beanClass = this.getClass(bean.getClazz(), defaultPackage);
                this.checkClassHasNotBeenProcessed(this.processedClasses, beanClass);
                this.annotationIgnores.setDefaultIgnoreAnnotation(beanClass, bean.isIgnoreAnnotations());
                this.parseClassLevelOverrides(bean.getClassType(), beanClass, defaultPackage);
                this.parseFieldLevelOverrides(bean.getField(), beanClass, defaultPackage);
                this.parsePropertyLevelOverrides(bean.getGetter(), beanClass, defaultPackage);
                this.processedClasses.add(beanClass);
            }
        }
    }

    public Set<Class<?>> getProcessedClasses() {
        return this.processedClasses;
    }

    public AnnotationIgnores getAnnotationIgnores() {
        return this.annotationIgnores;
    }

    public <T> List<MetaConstraint<T, ? extends Annotation>> getConstraintsForClass(Class<T> beanClass) {
        ArrayList<MetaConstraint<T, Annotation>> list = new ArrayList<MetaConstraint<T, Annotation>>();
        if (this.constraintMap.containsKey(beanClass)) {
            Iterator<MetaConstraint<?, Annotation>> i$ = this.constraintMap.get(beanClass).iterator();
            while (i$.hasNext()) {
                MetaConstraint<?, Annotation> metaConstraint;
                MetaConstraint<?, Annotation> boundMetaConstraint = metaConstraint = i$.next();
                list.add(boundMetaConstraint);
            }
            return list;
        }
        return Collections.emptyList();
    }

    public List<Member> getCascadedMembersForClass(Class<?> beanClass) {
        if (this.cascadedMembers.containsKey(beanClass)) {
            return this.cascadedMembers.get(beanClass);
        }
        return Collections.emptyList();
    }

    public List<Class<?>> getDefaultSequenceForClass(Class<?> beanClass) {
        if (this.defaultSequences.containsKey(beanClass)) {
            return this.defaultSequences.get(beanClass);
        }
        return Collections.emptyList();
    }

    private void parseConstraintDefinitions(List<ConstraintDefinitionType> constraintDefinitionList, String defaultPackage) {
        for (ConstraintDefinitionType constraintDefinition : constraintDefinitionList) {
            String annotationClassName = constraintDefinition.getAnnotation();
            Class<?> clazz = this.getClass(annotationClassName, defaultPackage);
            if (!clazz.isAnnotation()) {
                throw new ValidationException(annotationClassName + " is not an annotation");
            }
            Class<?> annotationClass = clazz;
            ValidatedByType validatedByType = constraintDefinition.getValidatedBy();
            ArrayList constraintValidatorClasses = new ArrayList();
            if (validatedByType.isIncludeExistingValidators() != null && validatedByType.isIncludeExistingValidators().booleanValue()) {
                constraintValidatorClasses.addAll(this.findConstraintValidatorClasses(annotationClass));
            }
            for (JAXBElement<String> validatorClassName : validatedByType.getValue()) {
                Class<?> validatorClass = this.loadClass((String)validatorClassName.getValue(), this.getClass());
                if (!ConstraintValidator.class.isAssignableFrom(validatorClass)) {
                    throw new ValidationException(validatorClass + " is not a constraint validator class");
                }
                constraintValidatorClasses.add(validatorClass);
            }
            this.constraintHelper.addConstraintValidatorDefinition(annotationClass, constraintValidatorClasses);
        }
    }

    private Class<?> loadClass(String className, Class<?> caller) {
        LoadClass action = LoadClass.action(className, caller);
        if (System.getSecurityManager() != null) {
            return (Class)AccessController.doPrivileged(action);
        }
        return action.run();
    }

    private List<Class<? extends ConstraintValidator<? extends Annotation, ?>>> findConstraintValidatorClasses(Class<? extends Annotation> annotationType) {
        ArrayList constraintValidatorDefinitionClasses = new ArrayList();
        if (this.constraintHelper.isBuiltinConstraint(annotationType)) {
            constraintValidatorDefinitionClasses.addAll(this.constraintHelper.getBuiltInConstraints(annotationType));
        } else {
            Class[] validatedBy = annotationType.getAnnotation(Constraint.class).validatedBy();
            constraintValidatorDefinitionClasses.addAll(Arrays.asList(validatedBy));
        }
        return constraintValidatorDefinitionClasses;
    }

    private void checkClassHasNotBeenProcessed(Set<Class<?>> processedClasses, Class<?> beanClass) {
        if (processedClasses.contains(beanClass)) {
            throw new ValidationException(beanClass.getName() + " has already be configured in xml.");
        }
    }

    private void parseFieldLevelOverrides(List<FieldType> fields, Class<?> beanClass, String defaultPackage) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (FieldType fieldType : fields) {
            boolean ignoreFieldAnnotation;
            String fieldName = fieldType.getName();
            if (fieldNames.contains(fieldName)) {
                throw new ValidationException(fieldName + " is defined twice in mapping xml for bean " + beanClass.getName());
            }
            fieldNames.add(fieldName);
            ContainsField containsAction = ContainsField.action(beanClass, fieldName);
            boolean containsField = System.getSecurityManager() != null ? AccessController.doPrivileged(containsAction).booleanValue() : containsAction.run().booleanValue();
            if (!containsField) {
                throw new ValidationException(beanClass.getName() + " does not contain the fieldType  " + fieldName);
            }
            GetDeclaredField action = GetDeclaredField.action(beanClass, fieldName);
            Field field = System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
            boolean bl = ignoreFieldAnnotation = fieldType.isIgnoreAnnotations() == null ? false : fieldType.isIgnoreAnnotations();
            if (ignoreFieldAnnotation) {
                this.annotationIgnores.setIgnoreAnnotationsOnMember(field);
            }
            if (fieldType.getValid() != null) {
                this.addCascadedMember(beanClass, field);
            }
            for (ConstraintType constraint : fieldType.getConstraint()) {
                MetaConstraint<?, ?> metaConstraint = this.createMetaConstraint(constraint, beanClass, field, defaultPackage);
                this.addMetaConstraint(beanClass, metaConstraint);
            }
        }
    }

    private void parsePropertyLevelOverrides(List<GetterType> getters, Class<?> beanClass, String defaultPackage) {
        ArrayList<String> getterNames = new ArrayList<String>();
        for (GetterType getterType : getters) {
            boolean ignoreGetterAnnotation;
            String getterName = getterType.getName();
            if (getterNames.contains(getterName)) {
                throw new ValidationException(getterName + " is defined twice in mapping xml for bean " + beanClass.getName());
            }
            getterNames.add(getterName);
            ContainsMethod cmAction = ContainsMethod.action(beanClass, getterName);
            boolean containsMethod = System.getSecurityManager() != null ? AccessController.doPrivileged(cmAction).booleanValue() : cmAction.run().booleanValue();
            if (!containsMethod) {
                throw new ValidationException(beanClass.getName() + " does not contain the property  " + getterName);
            }
            GetMethodFromPropertyName action = GetMethodFromPropertyName.action(beanClass, getterName);
            Method method = System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
            boolean bl = ignoreGetterAnnotation = getterType.isIgnoreAnnotations() == null ? false : getterType.isIgnoreAnnotations();
            if (ignoreGetterAnnotation) {
                this.annotationIgnores.setIgnoreAnnotationsOnMember(method);
            }
            if (getterType.getValid() != null) {
                this.addCascadedMember(beanClass, method);
            }
            for (ConstraintType constraint : getterType.getConstraint()) {
                MetaConstraint<?, ?> metaConstraint = this.createMetaConstraint(constraint, beanClass, method, defaultPackage);
                this.addMetaConstraint(beanClass, metaConstraint);
            }
        }
    }

    private void parseClassLevelOverrides(ClassType classType, Class<?> beanClass, String defaultPackage) {
        List<Class<?>> groupSequence;
        if (classType == null) {
            return;
        }
        if (classType.isIgnoreAnnotations() != null) {
            this.annotationIgnores.setIgnoreAnnotationsOnClass(beanClass, classType.isIgnoreAnnotations());
        }
        if (!(groupSequence = this.createGroupSequence(classType.getGroupSequence(), defaultPackage)).isEmpty()) {
            this.defaultSequences.put(beanClass, groupSequence);
        }
        for (ConstraintType constraint : classType.getConstraint()) {
            MetaConstraint<?, ?> metaConstraint = this.createMetaConstraint(constraint, beanClass, null, defaultPackage);
            this.addMetaConstraint(beanClass, metaConstraint);
        }
    }

    private void addMetaConstraint(Class<?> beanClass, MetaConstraint<?, ?> metaConstraint) {
        if (this.constraintMap.containsKey(beanClass)) {
            this.constraintMap.get(beanClass).add(metaConstraint);
        } else {
            ArrayList constraintList = new ArrayList();
            constraintList.add(metaConstraint);
            this.constraintMap.put(beanClass, constraintList);
        }
    }

    private void addCascadedMember(Class<?> beanClass, Member member) {
        if (this.cascadedMembers.containsKey(beanClass)) {
            this.cascadedMembers.get(beanClass).add(member);
        } else {
            ArrayList<Member> tmpList = new ArrayList<Member>();
            tmpList.add(member);
            this.cascadedMembers.put(beanClass, tmpList);
        }
    }

    private List<Class<?>> createGroupSequence(GroupSequenceType groupSequenceType, String defaultPackage) {
        ArrayList groupSequence = new ArrayList();
        if (groupSequenceType != null) {
            for (JAXBElement<String> groupName : groupSequenceType.getValue()) {
                Class<?> group = this.getClass((String)groupName.getValue(), defaultPackage);
                groupSequence.add(group);
            }
        }
        return groupSequence;
    }

    private <A extends Annotation, T> MetaConstraint<?, ?> createMetaConstraint(ConstraintType constraint, Class<T> beanClass, Member member, String defaultPackage) {
        Object annotation;
        Class<?> annotationClass = this.getClass(constraint.getAnnotation(), defaultPackage);
        AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(annotationClass);
        if (constraint.getMessage() != null) {
            annotationDescriptor.setValue(MESSAGE_PARAM, constraint.getMessage());
        }
        annotationDescriptor.setValue(GROUPS_PARAM, this.getGroups(constraint.getGroups(), defaultPackage));
        annotationDescriptor.setValue(PAYLOAD_PARAM, this.getPayload(constraint.getPayload(), defaultPackage));
        for (ElementType elementType : constraint.getElement()) {
            String name = elementType.getName();
            this.checkNameIsValid(name);
            Class<?> returnType = this.getAnnotationParameterType(annotationClass, name);
            Object elementValue = this.getElementValue(elementType, returnType);
            annotationDescriptor.setValue(name, elementValue);
        }
        try {
            annotation = AnnotationFactory.create(annotationDescriptor);
        }
        catch (RuntimeException e) {
            throw new ValidationException("Unable to create annotation for configured constraint: " + e.getMessage(), (Throwable)e);
        }
        java.lang.annotation.ElementType type = java.lang.annotation.ElementType.TYPE;
        if (member instanceof Method) {
            type = java.lang.annotation.ElementType.METHOD;
        } else if (member instanceof Field) {
            type = java.lang.annotation.ElementType.FIELD;
        }
        ConstraintDescriptorImpl constraintDescriptor = new ConstraintDescriptorImpl(annotation, this.constraintHelper, type, ConstraintOrigin.DEFINED_LOCALLY);
        return new MetaConstraint(beanClass, member, constraintDescriptor);
    }

    private <A extends Annotation> Class<?> getAnnotationParameterType(Class<A> annotationClass, String name) {
        GetMethod action = GetMethod.action(annotationClass, name);
        Method m = System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
        if (m == null) {
            throw new ValidationException("Annotation of type " + annotationClass.getName() + " does not contain a parameter " + name + PACKAGE_SEPARATOR);
        }
        return m.getReturnType();
    }

    private Object getElementValue(ElementType elementType, Class<?> returnType) {
        this.removeEmptyContentElements(elementType);
        boolean isArray = returnType.isArray();
        if (!isArray) {
            if (elementType.getContent().size() != 1) {
                throw new ValidationException("Attempt to specify an array where single value is expected.");
            }
            return this.getSingleValue(elementType.getContent().get(0), returnType);
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (Serializable s : elementType.getContent()) {
            values.add(this.getSingleValue(s, returnType.getComponentType()));
        }
        return values.toArray((Object[])Array.newInstance(returnType.getComponentType(), values.size()));
    }

    private void removeEmptyContentElements(ElementType elementType) {
        ArrayList<Serializable> contentToDelete = new ArrayList<Serializable>();
        for (Serializable content : elementType.getContent()) {
            if (!(content instanceof String) || !((String)((Object)content)).matches("[\\n ].*")) continue;
            contentToDelete.add(content);
        }
        elementType.getContent().removeAll(contentToDelete);
    }

    private Object getSingleValue(Serializable serializable, Class<?> returnType) {
        Object returnValue;
        if (serializable instanceof String) {
            String value = (String)((Object)serializable);
            returnValue = this.convertStringToReturnType(returnType, value);
        } else if (serializable instanceof JAXBElement && ((JAXBElement)serializable).getDeclaredType().equals(String.class)) {
            JAXBElement elem = (JAXBElement)serializable;
            String value = (String)elem.getValue();
            returnValue = this.convertStringToReturnType(returnType, value);
        } else if (serializable instanceof JAXBElement && ((JAXBElement)serializable).getDeclaredType().equals(AnnotationType.class)) {
            JAXBElement elem = (JAXBElement)serializable;
            AnnotationType annotationType = (AnnotationType)elem.getValue();
            try {
                Class<?> annotationClass = returnType;
                returnValue = this.createAnnotation(annotationType, annotationClass);
            }
            catch (ClassCastException e) {
                throw new ValidationException("Unexpected parameter value");
            }
        } else {
            throw new ValidationException("Unexpected parameter value");
        }
        return returnValue;
    }

    private <A extends Annotation> Annotation createAnnotation(AnnotationType annotationType, Class<A> returnType) {
        AnnotationDescriptor<A> annotationDescriptor = new AnnotationDescriptor<A>(returnType);
        for (ElementType elementType : annotationType.getElement()) {
            String name = elementType.getName();
            Class<?> parameterType = this.getAnnotationParameterType(returnType, name);
            Object elementValue = this.getElementValue(elementType, parameterType);
            annotationDescriptor.setValue(name, elementValue);
        }
        return AnnotationFactory.create(annotationDescriptor);
    }

    private Object convertStringToReturnType(Class<?> returnType, String value) {
        Class<?> returnValue;
        if (returnType.getName().equals(Byte.TYPE.getName())) {
            try {
                returnValue = Byte.parseByte(value);
            }
            catch (NumberFormatException e) {
                throw new ValidationException("Invalid byte format", (Throwable)e);
            }
        }
        if (returnType.getName().equals(Short.TYPE.getName())) {
            try {
                returnValue = Short.parseShort(value);
            }
            catch (NumberFormatException e) {
                throw new ValidationException("Invalid short format", (Throwable)e);
            }
        }
        if (returnType.getName().equals(Integer.TYPE.getName())) {
            try {
                returnValue = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new ValidationException("Invalid int format", (Throwable)e);
            }
        }
        if (returnType.getName().equals(Long.TYPE.getName())) {
            try {
                returnValue = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new ValidationException("Invalid long format", (Throwable)e);
            }
        }
        if (returnType.getName().equals(Float.TYPE.getName())) {
            try {
                returnValue = Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException e) {
                throw new ValidationException("Invalid float format", (Throwable)e);
            }
        }
        if (returnType.getName().equals(Double.TYPE.getName())) {
            try {
                returnValue = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new ValidationException("Invalid double format", (Throwable)e);
            }
        }
        if (returnType.getName().equals(Boolean.TYPE.getName())) {
            returnValue = Boolean.parseBoolean(value);
        } else if (returnType.getName().equals(Character.TYPE.getName())) {
            if (value.length() != 1) {
                throw new ValidationException("Invalid char value: " + value);
            }
            returnValue = Character.valueOf(value.charAt(0));
        } else if (returnType.getName().equals(String.class.getName())) {
            returnValue = value;
        } else if (returnType.getName().equals(Class.class.getName())) {
            returnValue = this.loadClass(value, this.getClass());
        } else {
            try {
                Class<?> enumClass = returnType;
                returnValue = Enum.valueOf(enumClass, value);
            }
            catch (ClassCastException e) {
                throw new ValidationException("Invalid return type: " + returnType + ". Should be a enumeration type.");
            }
        }
        return returnValue;
    }

    private void checkNameIsValid(String name) {
        if (MESSAGE_PARAM.equals(name) || GROUPS_PARAM.equals(name)) {
            throw new ValidationException("message, groups, payload are reserved parameter names.");
        }
    }

    private Class<?>[] getGroups(GroupsType groupsType, String defaultPackage) {
        if (groupsType == null) {
            return new Class[0];
        }
        ArrayList groupList = new ArrayList();
        for (JAXBElement<String> groupClass : groupsType.getValue()) {
            groupList.add(this.getClass((String)groupClass.getValue(), defaultPackage));
        }
        return groupList.toArray(new Class[groupList.size()]);
    }

    private Class<? extends Payload>[] getPayload(PayloadType payloadType, String defaultPackage) {
        if (payloadType == null) {
            return new Class[0];
        }
        ArrayList payloadList = new ArrayList();
        for (JAXBElement<String> groupClass : payloadType.getValue()) {
            Class<?> payload = this.getClass((String)groupClass.getValue(), defaultPackage);
            if (!Payload.class.isAssignableFrom(payload)) {
                throw new ValidationException("Specified payload class " + payload.getName() + " does not implement javax.validation.Payload");
            }
            payloadList.add(payload);
        }
        return payloadList.toArray(new Class[payloadList.size()]);
    }

    private Class<?> getClass(String clazz, String defaultPackage) {
        String fullyQualifiedClass = this.isQualifiedClass(clazz) ? clazz : defaultPackage + PACKAGE_SEPARATOR + clazz;
        return this.loadClass(fullyQualifiedClass, this.getClass());
    }

    private boolean isQualifiedClass(String clazz) {
        return clazz.contains(PACKAGE_SEPARATOR);
    }

    private ConstraintMappingsType getValidationConfig(InputStream in) {
        ConstraintMappingsType constraintMappings;
        Schema schema = this.getMappingSchema();
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ConstraintMappingsType.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(schema);
            StreamSource stream = new StreamSource(in);
            JAXBElement root = unmarshaller.unmarshal((Source)stream, ConstraintMappingsType.class);
            constraintMappings = (ConstraintMappingsType)root.getValue();
        }
        catch (JAXBException e) {
            String msg = "Error parsing mapping file.";
            log.error(msg);
            throw new ValidationException(msg, (Throwable)e);
        }
        return constraintMappings;
    }

    private Schema getMappingSchema() {
        boolean isSecured = System.getSecurityManager() != null;
        GetClassLoader action = GetClassLoader.fromClass(XmlMappingParser.class);
        ClassLoader loader = isSecured ? AccessController.doPrivileged(action) : action.run();
        URL schemaUrl = loader.getResource(VALIDATION_MAPPING_XSD);
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        try {
            schema = sf.newSchema(schemaUrl);
        }
        catch (SAXException e) {
            log.warn("Unable to create schema for {}: {}", (Object)VALIDATION_MAPPING_XSD, (Object)e.getMessage());
        }
        return schema;
    }
}

