/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class MetadataInspector {
    static String driver;
    static String dbURI;
    static String userName;
    static String passWord;
    static String table;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        MetadataInspector.readArgs(args);
        Connection conn = null;
        try {
            try {
                Class.forName(driver);
            }
            catch (Exception e) {
                System.err.println(e);
                System.exit(1);
            }
            conn = DriverManager.getConnection(dbURI, userName, passWord);
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT * from " + table);
            ResultSetMetaData rmd = rs.getMetaData();
            rs.next();
            if (rmd == null) {
                System.out.println("ResultSet meta data not available");
            } else {
                int columnCount = rmd.getColumnCount();
                System.out.println("Number of Columns in the table : " + columnCount);
                for (int i = 1; i <= columnCount; ++i) {
                    System.out.println("Column Name : " + rmd.getColumnName(i));
                    System.out.println("Column TypeName : " + rmd.getColumnTypeName(i));
                    System.out.println("Column type : " + rmd.getColumnType(i));
                    Object o = rs.getObject(i);
                    System.out.println("Column object class: " + o.getClass().getName());
                    switch (rmd.isNullable(i)) {
                        case 0: {
                            System.out.println("  NOT NULL");
                            break;
                        }
                        case 1: {
                            System.out.println("  NULLABLE");
                            break;
                        }
                        case 2: {
                            System.out.println("  NULLABLE Unkown");
                        }
                    }
                    System.out.println();
                }
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    System.out.println("Error in closing Conection");
                }
            }
        }
    }

    private static void readArgs(String[] args) {
        try {
            driver = args[0];
            dbURI = args[1];
            userName = args[2];
            passWord = args[3];
            table = args[4];
        }
        catch (Exception e) {
            System.out.printf("Usage: metadataInspector <driver> <dbUri> <userName> <passWord> <table>", new Object[0]);
            System.exit(1);
        }
    }
}

