/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.sqlserver.convertors;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import java.util.List;
import org.hibernate.spatial.dialect.sqlserver.convertors.AbstractGeometryCollectionDecoder;
import org.hibernate.spatial.dialect.sqlserver.convertors.OpenGisType;
import org.hibernate.spatial.jts.mgeom.MGeometryFactory;
import org.hibernate.spatial.jts.mgeom.MLineString;

class MultiLineStringDecoder
extends AbstractGeometryCollectionDecoder<MultiLineString> {
    public MultiLineStringDecoder(MGeometryFactory factory) {
        super(factory);
    }

    @Override
    protected OpenGisType getOpenGisType() {
        return OpenGisType.MULTILINESTRING;
    }

    @Override
    protected MultiLineString createGeometry(List<Geometry> geometries, boolean hasM) {
        if (hasM) {
            MLineString[] mlAr = geometries != null ? geometries.toArray(new MLineString[geometries.size()]) : null;
            return this.getGeometryFactory().createMultiMLineString(mlAr);
        }
        LineString[] lAr = geometries != null ? geometries.toArray(new LineString[geometries.size()]) : null;
        return this.getGeometryFactory().createMultiLineString(lAr);
    }
}

