/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.sqlserver.convertors;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.spatial.dialect.sqlserver.convertors.Encoder;
import org.hibernate.spatial.dialect.sqlserver.convertors.GeometryCollectionEncoder;
import org.hibernate.spatial.dialect.sqlserver.convertors.LineStringEncoder;
import org.hibernate.spatial.dialect.sqlserver.convertors.MultiPointEncoder;
import org.hibernate.spatial.dialect.sqlserver.convertors.OpenGisType;
import org.hibernate.spatial.dialect.sqlserver.convertors.PointEncoder;
import org.hibernate.spatial.dialect.sqlserver.convertors.PolygonEncoder;
import org.hibernate.spatial.dialect.sqlserver.convertors.SqlServerGeometry;

public class Encoders {
    private static final List<Encoder<? extends Geometry>> ENCODERS = new ArrayList<Encoder<? extends Geometry>>();

    public static Encoder<? extends Geometry> encoderFor(Geometry geom) {
        for (Encoder<? extends Geometry> encoder : ENCODERS) {
            if (!encoder.accepts(geom)) continue;
            return encoder;
        }
        throw new IllegalArgumentException("No encoder for type " + geom.getGeometryType());
    }

    public static <T extends Geometry> byte[] encode(T geom) {
        Encoder<? extends Geometry> encoder = Encoders.encoderFor(geom);
        SqlServerGeometry sqlServerGeometry = encoder.encode(geom);
        return SqlServerGeometry.serialize(sqlServerGeometry);
    }

    static {
        ENCODERS.add(new PointEncoder());
        ENCODERS.add(new LineStringEncoder());
        ENCODERS.add(new PolygonEncoder());
        ENCODERS.add(new MultiPointEncoder());
        ENCODERS.add(new GeometryCollectionEncoder(OpenGisType.MULTILINESTRING));
        ENCODERS.add(new GeometryCollectionEncoder(OpenGisType.MULTIPOLYGON));
        ENCODERS.add(new GeometryCollectionEncoder(OpenGisType.GEOMETRYCOLLECTION));
    }
}

