/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.sqlserver.convertors;

import com.vividsolutions.jts.geom.Geometry;
import org.hibernate.spatial.dialect.sqlserver.convertors.Decoder;
import org.hibernate.spatial.dialect.sqlserver.convertors.OpenGisType;
import org.hibernate.spatial.dialect.sqlserver.convertors.SqlServerGeometry;
import org.hibernate.spatial.jts.mgeom.MGeometryFactory;

abstract class AbstractDecoder<G extends Geometry>
implements Decoder<G> {
    private final MGeometryFactory geometryFactory;

    public AbstractDecoder(MGeometryFactory factory) {
        this.geometryFactory = factory;
    }

    @Override
    public G decode(SqlServerGeometry nativeGeom) {
        if (!this.accepts(nativeGeom)) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " received object of type " + (Object)((Object)nativeGeom.openGisType()));
        }
        if (nativeGeom.isEmpty()) {
            G nullGeom = this.createNullGeometry();
            this.setSrid(nativeGeom, nullGeom);
            return nullGeom;
        }
        G result = this.createGeometry(nativeGeom);
        this.setSrid(nativeGeom, result);
        return result;
    }

    @Override
    public boolean accepts(OpenGisType type) {
        return type == this.getOpenGisType();
    }

    @Override
    public boolean accepts(SqlServerGeometry nativeGeom) {
        return this.accepts(nativeGeom.openGisType());
    }

    protected abstract OpenGisType getOpenGisType();

    protected abstract G createNullGeometry();

    protected abstract G createGeometry(SqlServerGeometry var1);

    protected abstract G createGeometry(SqlServerGeometry var1, int var2);

    protected MGeometryFactory getGeometryFactory() {
        return this.geometryFactory;
    }

    protected void setSrid(SqlServerGeometry sqlServerGeom, G result) {
        if (sqlServerGeom.getSrid() != null) {
            result.setSRID(sqlServerGeom.getSrid().intValue());
        }
    }
}

