/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.sqlserver;

import com.vividsolutions.jts.geom.Geometry;
import java.sql.Blob;
import java.sql.SQLException;
import org.hibernate.spatial.dialect.AbstractJTSGeometryValueExtractor;
import org.hibernate.spatial.dialect.sqlserver.convertors.Decoders;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class SqlServer2008GeometryValueExtractor<X>
extends AbstractJTSGeometryValueExtractor<X> {
    public SqlServer2008GeometryValueExtractor(JavaTypeDescriptor<X> javaDescriptor, SqlTypeDescriptor sqlDescriptor) {
        super(javaDescriptor, sqlDescriptor);
    }

    @Override
    public Geometry toJTS(Object obj) {
        byte[] raw = null;
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            raw = (byte[])obj;
        } else if (obj instanceof Blob) {
            raw = this.toByteArray((Blob)obj);
        } else {
            throw new IllegalArgumentException("Expected byte array.");
        }
        return Decoders.decode(raw);
    }

    private byte[] toByteArray(Blob blob) {
        try {
            return blob.getBytes(1L, (int)blob.length());
        }
        catch (SQLException e) {
            throw new RuntimeException("Error on transforming blob into array.", e);
        }
    }
}

