/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle;

import com.vividsolutions.jts.geom.Geometry;
import java.util.List;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.type.Type;

class WrappedOGCFunction
extends StandardSQLFunction {
    private final boolean[] geomArrays;

    WrappedOGCFunction(String name, Type type, boolean[] geomArrays) {
        super(name, type);
        this.geomArrays = geomArrays;
    }

    public String render(Type firstArgumentType, List args, SessionFactoryImplementor factory) {
        StringBuffer buf = new StringBuffer();
        buf.append("MDSYS.").append(this.getName()).append("(");
        for (int i = 0; i < args.size(); ++i) {
            if (i > 0) {
                buf.append(",");
            }
            if (this.geomArrays[i]) {
                buf.append("MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(").append(args.get(i)).append(")");
                continue;
            }
            buf.append(args.get(i));
        }
        buf.append(")");
        return this.getType().getReturnedClass() == Geometry.class ? buf.append(".geom").toString() : buf.toString();
    }
}

