/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.sql.Struct;
import java.util.ArrayList;
import org.hibernate.HibernateException;
import org.hibernate.spatial.Circle;
import org.hibernate.spatial.dialect.AbstractJTSGeometryValueExtractor;
import org.hibernate.spatial.dialect.oracle.ElemInfo;
import org.hibernate.spatial.dialect.oracle.ElementType;
import org.hibernate.spatial.dialect.oracle.SDOGeometry;
import org.hibernate.spatial.jts.mgeom.MCoordinate;
import org.hibernate.spatial.jts.mgeom.MLineString;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class SDOGeometryValueExtractor<X>
extends AbstractJTSGeometryValueExtractor<X> {
    public SDOGeometryValueExtractor(JavaTypeDescriptor<X> javaDescriptor, SqlTypeDescriptor sqlDescriptor) {
        super(javaDescriptor, sqlDescriptor);
    }

    @Override
    public Geometry toJTS(Object struct) {
        if (struct == null) {
            return null;
        }
        SDOGeometry SDOGeom = SDOGeometry.load((Struct)struct);
        return this.convert2JTS(SDOGeom);
    }

    private Geometry convert2JTS(SDOGeometry SDOGeom) {
        int dim = SDOGeom.getGType().getDimension();
        int lrsDim = SDOGeom.getGType().getLRSDimension();
        Point result = null;
        switch (SDOGeom.getGType().getTypeGeometry()) {
            case POINT: {
                result = this.convertSDOPoint(SDOGeom);
                break;
            }
            case LINE: {
                result = this.convertSDOLine(dim, lrsDim, SDOGeom);
                break;
            }
            case POLYGON: {
                result = this.convertSDOPolygon(dim, lrsDim, SDOGeom);
                break;
            }
            case MULTIPOINT: {
                result = this.convertSDOMultiPoint(dim, lrsDim, SDOGeom);
                break;
            }
            case MULTILINE: {
                result = this.convertSDOMultiLine(dim, lrsDim, SDOGeom);
                break;
            }
            case MULTIPOLYGON: {
                result = this.convertSDOMultiPolygon(dim, lrsDim, SDOGeom);
                break;
            }
            case COLLECTION: {
                result = this.convertSDOCollection(dim, lrsDim, SDOGeom);
                break;
            }
            default: {
                throw new IllegalArgumentException("Type not supported: " + (Object)((Object)SDOGeom.getGType().getTypeGeometry()));
            }
        }
        result.setSRID(SDOGeom.getSRID());
        return result;
    }

    private Geometry convertSDOCollection(int dim, int lrsDim, SDOGeometry SDOGeom) {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        for (SDOGeometry elemGeom : SDOGeom.getElementGeometries()) {
            geometries.add(this.convert2JTS(elemGeom));
        }
        Geometry[] geomArray = new Geometry[geometries.size()];
        return this.getGeometryFactory().createGeometryCollection(geometries.toArray(geomArray));
    }

    private Point convertSDOPoint(SDOGeometry SDOGeom) {
        Double[] ordinates = SDOGeom.getOrdinates().getOrdinateArray();
        if (ordinates.length == 0) {
            ordinates = SDOGeom.getDimension() == 2 ? new Double[]{SDOGeom.getPoint().x, SDOGeom.getPoint().y} : new Double[]{SDOGeom.getPoint().x, SDOGeom.getPoint().y, SDOGeom.getPoint().z};
        }
        CoordinateSequence cs = this.convertOrdinateArray(ordinates, SDOGeom);
        Point point = this.getGeometryFactory().createPoint(cs);
        return point;
    }

    private MultiPoint convertSDOMultiPoint(int dim, int lrsDim, SDOGeometry SDOGeom) {
        Double[] ordinates = SDOGeom.getOrdinates().getOrdinateArray();
        CoordinateSequence cs = this.convertOrdinateArray(ordinates, SDOGeom);
        MultiPoint multipoint = this.getGeometryFactory().createMultiPoint(cs);
        return multipoint;
    }

    private LineString convertSDOLine(int dim, int lrsDim, SDOGeometry SDOGeom) {
        boolean lrs = SDOGeom.isLRSGeometry();
        ElemInfo info = SDOGeom.getInfo();
        CoordinateSequence cs = null;
        int i = 0;
        while (i < info.getSize()) {
            if (info.getElementType(i).isCompound()) {
                int numCompounds = info.getNumCompounds(i);
                cs = this.add(cs, this.getCompoundCSeq(i + 1, i + numCompounds, SDOGeom));
                i += 1 + numCompounds;
                continue;
            }
            cs = this.add(cs, this.getElementCSeq(i, SDOGeom, false));
            ++i;
        }
        MLineString ls = lrs ? this.getGeometryFactory().createMLineString(cs) : this.getGeometryFactory().createLineString(cs);
        return ls;
    }

    private MultiLineString convertSDOMultiLine(int dim, int lrsDim, SDOGeometry SDOGeom) {
        boolean lrs = SDOGeom.isLRSGeometry();
        ElemInfo info = SDOGeom.getInfo();
        LineString[] lines = lrs ? new MLineString[SDOGeom.getInfo().getSize()] : new LineString[SDOGeom.getInfo().getSize()];
        int i = 0;
        while (i < info.getSize()) {
            CoordinateSequence cs = null;
            if (info.getElementType(i).isCompound()) {
                int numCompounds = info.getNumCompounds(i);
                cs = this.add(cs, this.getCompoundCSeq(i + 1, i + numCompounds, SDOGeom));
                MLineString line = lrs ? this.getGeometryFactory().createMLineString(cs) : this.getGeometryFactory().createLineString(cs);
                lines[i] = line;
                i += 1 + numCompounds;
                continue;
            }
            cs = this.add(cs, this.getElementCSeq(i, SDOGeom, false));
            MLineString line = lrs ? this.getGeometryFactory().createMLineString(cs) : this.getGeometryFactory().createLineString(cs);
            lines[i] = line;
            ++i;
        }
        MultiLineString mls = lrs ? this.getGeometryFactory().createMultiMLineString((MLineString[])lines) : this.getGeometryFactory().createMultiLineString(lines);
        return mls;
    }

    private Geometry convertSDOPolygon(int dim, int lrsDim, SDOGeometry SDOGeom) {
        int numCompounds;
        LinearRing shell = null;
        LinearRing[] holes = new LinearRing[SDOGeom.getNumElements() - 1];
        ElemInfo info = SDOGeom.getInfo();
        int idxInteriorRings = 0;
        for (int i = 0; i < info.getSize(); i += 1 + numCompounds) {
            CoordinateSequence cs = null;
            numCompounds = 0;
            if (info.getElementType(i).isCompound()) {
                numCompounds = info.getNumCompounds(i);
                cs = this.add(cs, this.getCompoundCSeq(i + 1, i + numCompounds, SDOGeom));
            } else {
                cs = this.add(cs, this.getElementCSeq(i, SDOGeom, false));
            }
            if (info.getElementType(i).isInteriorRing()) {
                holes[idxInteriorRings] = this.getGeometryFactory().createLinearRing(cs);
                ++idxInteriorRings;
                continue;
            }
            shell = this.getGeometryFactory().createLinearRing(cs);
        }
        return this.getGeometryFactory().createPolygon(shell, holes);
    }

    private MultiPolygon convertSDOMultiPolygon(int dim, int lrsDim, SDOGeometry SDOGeom) {
        int numCompounds;
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        ElemInfo info = SDOGeom.getInfo();
        LinearRing shell = null;
        for (int i = 0; i < info.getSize(); i += 1 + numCompounds) {
            CoordinateSequence cs = null;
            numCompounds = 0;
            if (info.getElementType(i).isCompound()) {
                numCompounds = info.getNumCompounds(i);
                cs = this.add(cs, this.getCompoundCSeq(i + 1, i + numCompounds, SDOGeom));
            } else {
                cs = this.add(cs, this.getElementCSeq(i, SDOGeom, false));
            }
            if (info.getElementType(i).isInteriorRing()) {
                LinearRing lr = this.getGeometryFactory().createLinearRing(cs);
                holes.add(lr);
                continue;
            }
            if (shell != null) {
                Polygon polygon = this.getGeometryFactory().createPolygon(shell, holes.toArray(new LinearRing[holes.size()]));
                polygons.add(polygon);
                shell = null;
            }
            shell = this.getGeometryFactory().createLinearRing(cs);
            holes = new ArrayList();
        }
        if (shell != null) {
            Polygon polygon = this.getGeometryFactory().createPolygon(shell, holes.toArray(new LinearRing[holes.size()]));
            polygons.add(polygon);
        }
        MultiPolygon multiPolygon = this.getGeometryFactory().createMultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
        return multiPolygon;
    }

    private CoordinateSequence getCompoundCSeq(int idxFirst, int idxLast, SDOGeometry SDOGeom) {
        CoordinateSequence cs = null;
        for (int i = idxFirst; i <= idxLast; ++i) {
            if (cs != null && cs.size() > 0) {
                Coordinate[] coordinates = cs.toCoordinateArray();
                Coordinate[] newCoordinates = new Coordinate[coordinates.length - 1];
                System.arraycopy(coordinates, 0, newCoordinates, 0, coordinates.length - 1);
                cs = this.getGeometryFactory().getCoordinateSequenceFactory().create(newCoordinates);
            }
            cs = this.add(cs, this.getElementCSeq(i, SDOGeom, i < idxLast));
        }
        return cs;
    }

    private CoordinateSequence getElementCSeq(int i, SDOGeometry SDOGeom, boolean hasNextSE) {
        CoordinateSequence cs;
        ElementType type = SDOGeom.getInfo().getElementType(i);
        Double[] elemOrdinates = this.extractOrdinatesOfElement(i, SDOGeom, hasNextSE);
        if (type.isStraightSegment()) {
            cs = this.convertOrdinateArray(elemOrdinates, SDOGeom);
        } else if (type.isArcSegment() || type.isCircle()) {
            Coordinate[] linearized = this.linearize(elemOrdinates, SDOGeom.getDimension(), SDOGeom.isLRSGeometry(), type.isCircle());
            cs = this.getGeometryFactory().getCoordinateSequenceFactory().create(linearized);
        } else if (type.isRect()) {
            cs = this.convertOrdinateArray(elemOrdinates, SDOGeom);
            Coordinate ll = cs.getCoordinate(0);
            Coordinate ur = cs.getCoordinate(1);
            Coordinate lr = new Coordinate(ur.x, ll.y);
            Coordinate ul = new Coordinate(ll.x, ur.y);
            cs = type.isExteriorRing() ? this.getGeometryFactory().getCoordinateSequenceFactory().create(new Coordinate[]{ll, lr, ur, ul, ll}) : this.getGeometryFactory().getCoordinateSequenceFactory().create(new Coordinate[]{ll, ul, ur, lr, ll});
        } else {
            throw new RuntimeException("Unexpected Element type in compound: " + (Object)((Object)type));
        }
        return cs;
    }

    private CoordinateSequence add(CoordinateSequence seq1, CoordinateSequence seq2) {
        if (seq1 == null) {
            return seq2;
        }
        if (seq2 == null) {
            return seq1;
        }
        Coordinate[] c1 = seq1.toCoordinateArray();
        Coordinate[] c2 = seq2.toCoordinateArray();
        Coordinate[] c3 = new Coordinate[c1.length + c2.length];
        System.arraycopy(c1, 0, c3, 0, c1.length);
        System.arraycopy(c2, 0, c3, c1.length, c2.length);
        return this.getGeometryFactory().getCoordinateSequenceFactory().create(c3);
    }

    private Double[] extractOrdinatesOfElement(int element, SDOGeometry SDOGeom, boolean hasNextSE) {
        int start = SDOGeom.getInfo().getOrdinatesOffset(element);
        if (element < SDOGeom.getInfo().getSize() - 1) {
            int end = SDOGeom.getInfo().getOrdinatesOffset(element + 1);
            if (hasNextSE) {
                end += SDOGeom.getDimension();
            }
            return SDOGeom.getOrdinates().getOrdinatesArray(start, end);
        }
        return SDOGeom.getOrdinates().getOrdinatesArray(start);
    }

    private CoordinateSequence convertOrdinateArray(Double[] oordinates, SDOGeometry SDOGeom) {
        int dim = SDOGeom.getDimension();
        Coordinate[] coordinates = new Coordinate[oordinates.length / dim];
        int zDim = SDOGeom.getZDimension() - 1;
        int lrsDim = SDOGeom.getLRSDimension() - 1;
        for (int i = 0; i < coordinates.length; ++i) {
            if (dim == 2) {
                coordinates[i] = new Coordinate(oordinates[i * dim].doubleValue(), oordinates[i * dim + 1].doubleValue());
                continue;
            }
            if (dim == 3) {
                if (SDOGeom.isLRSGeometry()) {
                    coordinates[i] = MCoordinate.create2dWithMeasure(oordinates[i * dim], oordinates[i * dim + 1], oordinates[i * dim + lrsDim]);
                    continue;
                }
                coordinates[i] = new Coordinate(oordinates[i * dim].doubleValue(), oordinates[i * dim + 1].doubleValue(), oordinates[i * dim + zDim].doubleValue());
                continue;
            }
            if (dim != 4) continue;
            if (!SDOGeom.isLRSGeometry()) {
                throw new HibernateException("4 dimensional Geometries must be LRS geometry");
            }
            coordinates[i] = MCoordinate.create3dWithMeasure(oordinates[i * dim], oordinates[i * dim + 1], oordinates[i * dim + zDim], oordinates[i * dim + lrsDim]);
        }
        return this.getGeometryFactory().getCoordinateSequenceFactory().create(coordinates);
    }

    private Coordinate[] linearize(Double[] arcOrdinates, int dim, boolean lrs, boolean entireCirlce) {
        int coordDim;
        Coordinate[] linearizedCoords = new Coordinate[]{};
        int n = coordDim = lrs ? dim - 1 : dim;
        if (coordDim != 2) {
            throw new IllegalArgumentException("Can only linearize 2D arc segments, but geometry is " + dim + "D.");
        }
        int numOrd = dim;
        while (numOrd < arcOrdinates.length) {
            numOrd -= dim;
            double x1 = arcOrdinates[numOrd++];
            double y1 = arcOrdinates[numOrd++];
            double m1 = lrs ? arcOrdinates[numOrd++] : Double.NaN;
            double x2 = arcOrdinates[numOrd++];
            double y2 = arcOrdinates[numOrd++];
            double m2 = lrs ? arcOrdinates[numOrd++] : Double.NaN;
            double x3 = arcOrdinates[numOrd++];
            double y3 = arcOrdinates[numOrd++];
            double m3 = lrs ? arcOrdinates[numOrd++] : Double.NaN;
            Coordinate[] coords = entireCirlce ? Circle.linearizeCircle(x1, y1, x2, y2, x3, y3) : Circle.linearizeArc(x1, y1, x2, y2, x3, y3);
            if (lrs) {
                MCoordinate[] mcoord = new MCoordinate[coords.length];
                int lastIndex = coords.length - 1;
                mcoord[0] = MCoordinate.create2dWithMeasure(x1, y1, m1);
                mcoord[lastIndex] = MCoordinate.create2dWithMeasure(x3, y3, m3);
                for (int i = 1; i < lastIndex; ++i) {
                    mcoord[i] = MCoordinate.convertCoordinate(coords[i]);
                    if (Double.compare(mcoord[i].x, x2) != 0 || Double.compare(mcoord[i].y, y2) != 0) continue;
                    mcoord[i].m = m2;
                }
                coords = mcoord;
            }
            int resultBegin = 1;
            if (linearizedCoords.length == 0) {
                resultBegin = 0;
            }
            int destPos = linearizedCoords.length;
            Coordinate[] tmpCoords = new Coordinate[linearizedCoords.length + coords.length - resultBegin];
            System.arraycopy(linearizedCoords, 0, tmpCoords, 0, linearizedCoords.length);
            System.arraycopy(coords, resultBegin, tmpCoords, destPos, coords.length - resultBegin);
            linearizedCoords = tmpCoords;
        }
        return linearizedCoords;
    }
}

