/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.spatial.dialect.oracle.ElemInfo;
import org.hibernate.spatial.dialect.oracle.ElementType;
import org.hibernate.spatial.dialect.oracle.OracleJDBCTypeFactory;
import org.hibernate.spatial.dialect.oracle.Ordinates;
import org.hibernate.spatial.dialect.oracle.SDOGType;
import org.hibernate.spatial.dialect.oracle.SDOGeometry;
import org.hibernate.spatial.dialect.oracle.TypeGeometry;
import org.hibernate.spatial.helper.FinderException;
import org.hibernate.spatial.jts.JTS;
import org.hibernate.spatial.jts.mgeom.MCoordinate;
import org.hibernate.spatial.jts.mgeom.MGeometryFactory;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;

public class SDOGeometryValueBinder
implements ValueBinder<Geometry> {
    private final OracleJDBCTypeFactory typeFactory;

    public SDOGeometryValueBinder(OracleJDBCTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    public void bind(PreparedStatement st, Geometry value, int index, WrapperOptions options) throws SQLException {
        if (value == null) {
            st.setNull(index, 2002, SDOGeometry.getTypeName());
        } else {
            Geometry jtsGeom = value;
            Object dbGeom = this.toNative(jtsGeom, st.getConnection());
            st.setObject(index, dbGeom);
        }
    }

    public MGeometryFactory getGeometryFactory() {
        return JTS.getDefaultGeomFactory();
    }

    public Object store(SDOGeometry geom, Connection conn) throws SQLException, FinderException {
        return this.typeFactory.createStruct(geom, conn);
    }

    private Object toNative(Geometry jtsGeom, Connection connection) {
        SDOGeometry geom = this.convertJTSGeometry(jtsGeom);
        if (geom != null) {
            try {
                return this.store(geom, connection);
            }
            catch (SQLException e) {
                throw new HibernateException("Problem during conversion from JTS to SDOGeometry", (Throwable)e);
            }
            catch (FinderException e) {
                throw new HibernateException("OracleConnection could not be retrieved for creating SDOGeometry STRUCT", (Throwable)e);
            }
        }
        throw new UnsupportedOperationException("Conversion of " + jtsGeom.getClass().getSimpleName() + " to Oracle STRUCT not supported");
    }

    private SDOGeometry convertJTSGeometry(Geometry jtsGeom) {
        SDOGeometry geom = null;
        if (jtsGeom instanceof Point) {
            geom = this.convertJTSPoint((Point)jtsGeom);
        } else if (jtsGeom instanceof LineString) {
            geom = this.convertJTSLineString((LineString)jtsGeom);
        } else if (jtsGeom instanceof Polygon) {
            geom = this.convertJTSPolygon((Polygon)jtsGeom);
        } else if (jtsGeom instanceof MultiPoint) {
            geom = this.convertJTSMultiPoint((MultiPoint)jtsGeom);
        } else if (jtsGeom instanceof MultiLineString) {
            geom = this.convertJTSMultiLineString((MultiLineString)jtsGeom);
        } else if (jtsGeom instanceof MultiPolygon) {
            geom = this.convertJTSMultiPolygon((MultiPolygon)jtsGeom);
        } else if (jtsGeom instanceof GeometryCollection) {
            geom = this.convertJTSGeometryCollection((GeometryCollection)jtsGeom);
        }
        return geom;
    }

    private SDOGeometry convertJTSGeometryCollection(GeometryCollection collection) {
        SDOGeometry[] SDOElements = new SDOGeometry[collection.getNumGeometries()];
        for (int i = 0; i < collection.getNumGeometries(); ++i) {
            Geometry geom = collection.getGeometryN(i);
            SDOElements[i] = this.convertJTSGeometry(geom);
        }
        SDOGeometry ccollect = SDOGeometry.join(SDOElements);
        ccollect.setSRID(collection.getSRID());
        return ccollect;
    }

    private SDOGeometry convertJTSMultiPolygon(MultiPolygon multiPolygon) {
        int dim = this.getCoordDimension((Geometry)multiPolygon);
        int lrsPos = this.getCoordinateLrsPosition((Geometry)multiPolygon);
        SDOGeometry geom = new SDOGeometry();
        geom.setGType(new SDOGType(dim, lrsPos, TypeGeometry.MULTIPOLYGON));
        geom.setSRID(multiPolygon.getSRID());
        for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
            try {
                Polygon pg = (Polygon)multiPolygon.getGeometryN(i);
                this.addPolygon(geom, pg);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Found geometry that was not a geometry in MultiPolygon");
            }
        }
        return geom;
    }

    private SDOGeometry convertJTSLineString(LineString lineString) {
        int dim = this.getCoordDimension((Geometry)lineString);
        int lrsPos = this.getCoordinateLrsPosition((Geometry)lineString);
        boolean isLrs = lrsPos > 0;
        Double[] ordinates = this.convertCoordinates(lineString.getCoordinates(), dim, isLrs);
        SDOGeometry geom = new SDOGeometry();
        geom.setGType(new SDOGType(dim, lrsPos, TypeGeometry.LINE));
        geom.setSRID(lineString.getSRID());
        ElemInfo info = new ElemInfo(1);
        info.setElement(0, 1, ElementType.LINE_STRAITH_SEGMENTS, 0);
        geom.setInfo(info);
        geom.setOrdinates(new Ordinates(ordinates));
        return geom;
    }

    private SDOGeometry convertJTSMultiPoint(MultiPoint multiPoint) {
        int dim = this.getCoordDimension((Geometry)multiPoint);
        int lrsDim = this.getCoordinateLrsPosition((Geometry)multiPoint);
        boolean isLrs = lrsDim != 0;
        SDOGeometry geom = new SDOGeometry();
        geom.setGType(new SDOGType(dim, lrsDim, TypeGeometry.MULTIPOINT));
        geom.setSRID(multiPoint.getSRID());
        ElemInfo info = new ElemInfo(multiPoint.getNumPoints());
        int oordinatesOffset = 1;
        Double[] ordinates = new Double[]{};
        for (int i = 0; i < multiPoint.getNumPoints(); ++i) {
            info.setElement(i, oordinatesOffset, ElementType.POINT, 0);
            ordinates = this.convertAddCoordinates(ordinates, multiPoint.getGeometryN(i).getCoordinates(), dim, isLrs);
            oordinatesOffset = ordinates.length + 1;
        }
        geom.setInfo(info);
        geom.setOrdinates(new Ordinates(ordinates));
        return geom;
    }

    private SDOGeometry convertJTSPoint(Point jtsGeom) {
        int dim = this.getCoordDimension((Geometry)jtsGeom);
        int lrsDim = this.getCoordinateLrsPosition((Geometry)jtsGeom);
        boolean isLrs = lrsDim != 0;
        Double[] coord = this.convertCoordinates(jtsGeom.getCoordinates(), dim, isLrs);
        SDOGeometry geom = new SDOGeometry();
        geom.setGType(new SDOGType(dim, lrsDim, TypeGeometry.POINT));
        geom.setSRID(jtsGeom.getSRID());
        ElemInfo info = new ElemInfo(1);
        info.setElement(0, 1, ElementType.POINT, 1);
        geom.setInfo(info);
        geom.setOrdinates(new Ordinates(coord));
        return geom;
    }

    private SDOGeometry convertJTSPolygon(Polygon polygon) {
        int dim = this.getCoordDimension((Geometry)polygon);
        int lrsPos = this.getCoordinateLrsPosition((Geometry)polygon);
        SDOGeometry geom = new SDOGeometry();
        geom.setGType(new SDOGType(dim, lrsPos, TypeGeometry.POLYGON));
        geom.setSRID(polygon.getSRID());
        this.addPolygon(geom, polygon);
        return geom;
    }

    private void addPolygon(SDOGeometry geom, Polygon polygon) {
        int numInteriorRings = polygon.getNumInteriorRing();
        ElemInfo info = new ElemInfo(numInteriorRings + 1);
        int ordinatesPreviousOffset = 0;
        if (geom.getOrdinates() != null) {
            ordinatesPreviousOffset = geom.getOrdinates().getOrdinateArray().length;
        }
        int ordinatesOffset = ordinatesPreviousOffset + 1;
        Double[] ordinates = new Double[]{};
        for (int i = 0; i < info.getSize(); ++i) {
            Coordinate[] coords;
            ElementType et;
            if (i == 0) {
                et = ElementType.EXTERIOR_RING_STRAIGHT_SEGMENTS;
                coords = polygon.getExteriorRing().getCoordinates();
                if (!CGAlgorithms.isCCW((Coordinate[])coords)) {
                    coords = this.reverseRing(coords);
                }
            } else {
                et = ElementType.INTERIOR_RING_STRAIGHT_SEGMENTS;
                coords = polygon.getInteriorRingN(i - 1).getCoordinates();
                if (CGAlgorithms.isCCW((Coordinate[])coords)) {
                    coords = this.reverseRing(coords);
                }
            }
            info.setElement(i, ordinatesOffset, et, 0);
            ordinates = this.convertAddCoordinates(ordinates, coords, geom.getDimension(), geom.isLRSGeometry());
            ordinatesOffset = ordinatesPreviousOffset + ordinates.length + 1;
        }
        geom.addElement(info);
        geom.addOrdinates(ordinates);
    }

    private SDOGeometry convertJTSMultiLineString(MultiLineString multiLineString) {
        int dim = this.getCoordDimension((Geometry)multiLineString);
        int lrsDim = this.getCoordinateLrsPosition((Geometry)multiLineString);
        boolean isLrs = lrsDim != 0;
        SDOGeometry geom = new SDOGeometry();
        geom.setGType(new SDOGType(dim, lrsDim, TypeGeometry.MULTILINE));
        geom.setSRID(multiLineString.getSRID());
        ElemInfo info = new ElemInfo(multiLineString.getNumGeometries());
        int oordinatesOffset = 1;
        Double[] ordinates = new Double[]{};
        for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
            info.setElement(i, oordinatesOffset, ElementType.LINE_STRAITH_SEGMENTS, 0);
            ordinates = this.convertAddCoordinates(ordinates, multiLineString.getGeometryN(i).getCoordinates(), dim, isLrs);
            oordinatesOffset = ordinates.length + 1;
        }
        geom.setInfo(info);
        geom.setOrdinates(new Ordinates(ordinates));
        return geom;
    }

    private Double[] convertAddCoordinates(Double[] ordinates, Coordinate[] coordinates, int dim, boolean isLrs) {
        Double[] no = this.convertCoordinates(coordinates, dim, isLrs);
        Double[] newordinates = new Double[ordinates.length + no.length];
        System.arraycopy(ordinates, 0, newordinates, 0, ordinates.length);
        System.arraycopy(no, 0, newordinates, ordinates.length, no.length);
        return newordinates;
    }

    private Double[] convertCoordinates(Coordinate[] coordinates, int dim, boolean isLrs) {
        if (dim > 4) {
            throw new IllegalArgumentException("Dim parameter value cannot be greater than 4");
        }
        Double[] converted = new Double[coordinates.length * dim];
        for (int i = 0; i < coordinates.length; ++i) {
            MCoordinate c = MCoordinate.convertCoordinate(coordinates[i]);
            converted[i * dim] = this.toDouble(c.x);
            converted[i * dim + 1] = this.toDouble(c.y);
            if (dim == 3) {
                converted[i * dim + 2] = isLrs ? this.toDouble(c.m) : this.toDouble(c.z);
                continue;
            }
            if (dim != 4) continue;
            converted[i * dim + 2] = this.toDouble(c.z);
            converted[i * dim + 3] = this.toDouble(c.m);
        }
        return converted;
    }

    private Double toDouble(double d) {
        return Double.isNaN(d) ? null : Double.valueOf(d);
    }

    private int getCoordDimension(Geometry geom) {
        MCoordinate c = MCoordinate.convertCoordinate(geom.getCoordinate());
        int d = 0;
        if (c != null) {
            if (!Double.isNaN(c.x)) {
                ++d;
            }
            if (!Double.isNaN(c.y)) {
                ++d;
            }
            if (!Double.isNaN(c.z)) {
                ++d;
            }
            if (!Double.isNaN(c.m)) {
                ++d;
            }
        }
        return d;
    }

    private int getCoordinateLrsPosition(Geometry geom) {
        MCoordinate c = MCoordinate.convertCoordinate(geom.getCoordinate());
        int measurePos = 0;
        if (c != null && !Double.isNaN(c.m)) {
            measurePos = Double.isNaN(c.z) ? 3 : 4;
        }
        return measurePos;
    }

    private Coordinate[] reverseRing(Coordinate[] ar) {
        for (int i = 0; i < ar.length / 2; ++i) {
            Coordinate cs = ar[i];
            ar[i] = ar[ar.length - 1 - i];
            ar[ar.length - 1 - i] = cs;
        }
        return ar;
    }
}

