/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import org.hibernate.HibernateException;
import org.hibernate.spatial.dialect.oracle.ConnectionFinder;
import org.hibernate.spatial.helper.FinderException;

public class DefaultConnectionFinder
implements ConnectionFinder {
    private static final Class<?> oracleConnectionClass;

    @Override
    public Connection find(Connection con) throws FinderException {
        if (con == null) {
            return null;
        }
        if (oracleConnectionClass.isInstance(con)) {
            return con;
        }
        for (Method method : con.getClass().getMethods()) {
            if (!method.getReturnType().isAssignableFrom(Connection.class) || method.getParameterTypes().length != 0) continue;
            try {
                method.setAccessible(true);
                Connection oc = this.find((Connection)method.invoke((Object)con, new Object[0]));
                if (oc == null) {
                    throw new FinderException(String.format("Tried retrieving OracleConnection from %s using method %s, but received null.", con.getClass().getCanonicalName(), method.getName()));
                }
                return oc;
            }
            catch (IllegalAccessException e) {
                throw new FinderException(String.format("Illegal access on executing method %s when finding OracleConnection", method.getName()));
            }
            catch (InvocationTargetException e) {
                throw new FinderException(String.format("Invocation exception on executing method %s when finding OracleConnection", method.getName()));
            }
        }
        throw new FinderException("Couldn't get at the OracleSpatial Connection object from the PreparedStatement.");
    }

    static {
        try {
            oracleConnectionClass = Class.forName("oracle.jdbc.driver.OracleConnection");
        }
        catch (ClassNotFoundException e) {
            throw new HibernateException("Can't find Oracle JDBC Driver on classpath.");
        }
    }
}

