/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.mysql;

import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.dialect.MySQLInnoDBDialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.dialect.mysql.MySQLSpatialDialect;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class MySQLSpatialInnoDBDialect
extends MySQLInnoDBDialect
implements SpatialDialect {
    private MySQLSpatialDialect dialectDelegate = new MySQLSpatialDialect();

    public MySQLSpatialInnoDBDialect() {
        Map<String, StandardSQLFunction> functionsToRegister = this.dialectDelegate.getFunctionsToRegister();
        Map<String, Integer> columnTypes = this.dialectDelegate.getColumnTypesToRegister();
        if (null != columnTypes) {
            for (String aKey : columnTypes.keySet()) {
                this.registerColumnType(columnTypes.get(aKey), aKey);
            }
        }
        if (null != functionsToRegister) {
            for (String aKey : functionsToRegister.keySet()) {
                this.registerFunction(aKey, (SQLFunction)functionsToRegister.get(aKey));
            }
        }
    }

    public SqlTypeDescriptor remapSqlTypeDescriptor(SqlTypeDescriptor sqlTypeDescriptor) {
        return this.dialectDelegate.remapSqlTypeDescriptor(sqlTypeDescriptor);
    }

    public String getTypeName(int code, long length, int precision, int scale) throws HibernateException {
        return this.dialectDelegate.getTypeName(code, length, precision, scale);
    }

    @Override
    public String getSpatialRelateSQL(String columnName, int spatialRelation) {
        return this.dialectDelegate.getSpatialRelateSQL(columnName, spatialRelation);
    }

    @Override
    public String getSpatialFilterExpression(String columnName) {
        return this.dialectDelegate.getSpatialFilterExpression(columnName);
    }

    @Override
    public String getSpatialAggregateSQL(String columnName, int aggregation) {
        return this.dialectDelegate.getSpatialAggregateSQL(columnName, aggregation);
    }

    @Override
    public String getDWithinSQL(String columnName) {
        return this.dialectDelegate.getDWithinSQL(columnName);
    }

    @Override
    public String getHavingSridSQL(String columnName) {
        return this.dialectDelegate.getHavingSridSQL(columnName);
    }

    @Override
    public String getIsEmptySQL(String columnName, boolean isEmpty) {
        return this.dialectDelegate.getIsEmptySQL(columnName, isEmpty);
    }

    public String getDbGeometryTypeName() {
        return this.dialectDelegate.getDbGeometryTypeName();
    }

    @Override
    public boolean supportsFiltering() {
        return this.dialectDelegate.supportsFiltering();
    }

    @Override
    public boolean supports(SpatialFunction function) {
        return this.dialectDelegate.supports(function);
    }
}

