/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.mysql;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKBReader;
import org.hibernate.spatial.dialect.AbstractJTSGeometryValueExtractor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class MySQLGeometryValueExtractor<X>
extends AbstractJTSGeometryValueExtractor<X> {
    private static final int SRIDLEN = 4;

    public MySQLGeometryValueExtractor(JavaTypeDescriptor<X> javaDescriptor, SqlTypeDescriptor sqlDescriptor) {
        super(javaDescriptor, sqlDescriptor);
    }

    @Override
    public Geometry toJTS(Object object) {
        if (object == null) {
            return null;
        }
        byte[] data = (byte[])object;
        byte[] wkb = new byte[data.length - 4];
        System.arraycopy(data, 4, wkb, 0, wkb.length);
        int srid = 0;
        srid = data[3] << 24 | (data[2] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | data[0] & 0xFF;
        Geometry geom = null;
        try {
            WKBReader reader = new WKBReader();
            geom = reader.read(wkb);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't parse incoming MySQL Spatial data.");
        }
        geom.setSRID(srid);
        return geom;
    }
}

