/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.criterion;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.dialect.Dialect;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.SpatialFunction;

public class ExpressionUtil {
    public static SpatialDialect getSpatialDialect(CriteriaQuery criteriaQuery, SpatialFunction function) {
        Dialect dialect = criteriaQuery.getFactory().getDialect();
        if (!(dialect instanceof SpatialDialect)) {
            throw new HibernateException("A spatial expression requires a spatial dialect.");
        }
        SpatialDialect spatialDialect = (SpatialDialect)dialect;
        if (!spatialDialect.supports(function)) {
            throw new HibernateException((Object)((Object)function) + " function not supported by this dialect");
        }
        return spatialDialect;
    }

    public static String findColumn(String propertyName, Criteria criteria, CriteriaQuery criteriaQuery) {
        String[] columns = criteriaQuery.findColumns(propertyName, criteria);
        if (columns.length != 1) {
            throw new HibernateException("Spatial Expression may only be used with single-column properties");
        }
        return columns[0];
    }
}

