/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.ExtendableCriterion;
import org.hibernate.envers.query.criteria.internal.CriteriaTools;
import org.hibernate.envers.query.internal.property.PropertyNameGetter;

public class AggregatedAuditExpression
implements AuditCriterion,
ExtendableCriterion {
    private PropertyNameGetter propertyNameGetter;
    private AggregatedMode mode;
    private boolean correlate;
    private List<AuditCriterion> criterions;

    public AggregatedAuditExpression(PropertyNameGetter propertyNameGetter, AggregatedMode mode) {
        this.propertyNameGetter = propertyNameGetter;
        this.mode = mode;
        this.criterions = new ArrayList<AuditCriterion>();
    }

    @Override
    public AggregatedAuditExpression add(AuditCriterion criterion) {
        this.criterions.add(criterion);
        return this;
    }

    @Override
    public void addToQuery(EnversService enversService, AuditReaderImplementor versionsReader, String entityName, QueryBuilder qb, Parameters parameters) {
        String propertyName = CriteriaTools.determinePropertyName(enversService, versionsReader, entityName, this.propertyNameGetter);
        CriteriaTools.checkPropertyNotARelation(enversService, entityName, propertyName);
        Parameters subParams = parameters.addSubParameters("and");
        QueryBuilder subQb = qb.newSubQueryBuilder();
        for (AuditCriterion versionsCriteria : this.criterions) {
            versionsCriteria.addToQuery(enversService, versionsReader, entityName, qb, subParams);
            versionsCriteria.addToQuery(enversService, versionsReader, entityName, subQb, subQb.getRootParameters());
        }
        switch (this.mode) {
            case MIN: {
                subQb.addProjection("min", propertyName, false);
                break;
            }
            case MAX: {
                subQb.addProjection("max", propertyName, false);
            }
        }
        if (this.correlate) {
            String originalIdPropertyName = enversService.getAuditEntitiesConfiguration().getOriginalIdPropName();
            enversService.getEntitiesConfigurations().get(entityName).getIdMapper().addIdsEqualToQuery(subQb.getRootParameters(), subQb.getRootAlias() + "." + originalIdPropertyName, qb.getRootAlias() + "." + originalIdPropertyName);
        }
        subParams.addWhere(propertyName, "=", subQb);
    }

    public AggregatedAuditExpression computeAggregationInInstanceContext() {
        this.correlate = true;
        return this;
    }

    public static enum AggregatedMode {
        MAX,
        MIN;

    }
}

