/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.proxy.hosted;

import com.oracle.svm.core.configure.ConditionalElement;
import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.ConditionalConfigurationRegistry;
import com.oracle.svm.hosted.ConfigurationTypeResolver;
import com.oracle.svm.hosted.ImageClassLoader;
import java.util.List;
import java.util.function.Consumer;

public class ProxyRegistry
extends ConditionalConfigurationRegistry
implements Consumer<ConditionalElement<List<String>>> {
    private final ConfigurationTypeResolver typeResolver;
    private final DynamicProxyRegistry dynamicProxySupport;
    private final ImageClassLoader imageClassLoader;

    public ProxyRegistry(ConfigurationTypeResolver typeResolver, DynamicProxyRegistry dynamicProxySupport, ImageClassLoader imageClassLoader) {
        this.typeResolver = typeResolver;
        this.dynamicProxySupport = dynamicProxySupport;
        this.imageClassLoader = imageClassLoader;
    }

    @Override
    public void accept(ConditionalElement<List<String>> proxies) {
        if (this.typeResolver.resolveType(proxies.getCondition().getTypeName()) == null) {
            return;
        }
        List<String> interfaceNames = proxies.getElement();
        Class[] interfaces = new Class[interfaceNames.size()];
        for (int i = 0; i < interfaceNames.size(); ++i) {
            String className = interfaceNames.get(i);
            Class<?> clazz = this.imageClassLoader.findClass(className).get();
            if (clazz == null) {
                throw UserError.abort("Class %s not found.", className);
            }
            if (!clazz.isInterface()) {
                throw UserError.abort("The class %s is not an interface.", className);
            }
            interfaces[i] = clazz;
        }
        this.registerConditionalConfiguration(proxies.getCondition(), () -> this.dynamicProxySupport.addProxyClass(interfaces));
    }
}

