/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.proxy;

import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.PredefinedClassesSupport;
import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.util.ClassUtil;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public class DynamicProxySupport
implements DynamicProxyRegistry {
    private static final String proxyConfigFilesOption = SubstrateOptionsParser.commandArgument(ConfigurationFiles.Options.DynamicProxyConfigurationFiles, "<comma-separated-config-files>");
    private static final String proxyConfigResourcesOption = SubstrateOptionsParser.commandArgument(ConfigurationFiles.Options.DynamicProxyConfigurationResources, "<comma-separated-config-resources>");
    private final ClassLoader classLoader;
    private final Map<ProxyCacheKey, Object> proxyCache;

    public DynamicProxySupport(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.proxyCache = new ConcurrentHashMap<ProxyCacheKey, Object>();
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void addProxyClass(Class<?> ... interfaces) {
        Class[] intfs = (Class[])interfaces.clone();
        ProxyCacheKey key = new ProxyCacheKey(intfs);
        this.proxyCache.computeIfAbsent(key, k -> {
            Class<?> clazz;
            try {
                clazz = DynamicProxySupport.getJdkProxyClass(this.classLoader, intfs);
            }
            catch (Throwable e) {
                if (NativeImageOptions.AllowIncompleteClasspath.getValue().booleanValue()) {
                    return e;
                }
                throw e;
            }
            PredefinedClassesSupport.registerClass(clazz);
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupConstructor(clazz, (Class[])new Class[]{InvocationHandler.class})});
            for (Class intf : intfs) {
                RuntimeReflection.register((Executable[])intf.getMethods());
            }
            return clazz;
        });
    }

    @Override
    public Class<?> getProxyClass(ClassLoader loader, Class<?> ... interfaces) {
        ProxyCacheKey key = new ProxyCacheKey((Class[])interfaces);
        Object clazzOrError = this.proxyCache.get(key);
        if (clazzOrError == null) {
            throw VMError.unsupportedFeature("Proxy class defined by interfaces " + Arrays.toString(interfaces) + " not found. Generating proxy classes at runtime is not supported. Proxy classes need to be defined at image build time by specifying the list of interfaces that they implement. To define proxy classes use " + proxyConfigFilesOption + " and " + proxyConfigResourcesOption + " options.");
        }
        if (clazzOrError instanceof Throwable) {
            throw new GraalError((Throwable)clazzOrError);
        }
        Class clazz = (Class)clazzOrError;
        if (!DynamicHub.fromClass(clazz).isLoaded()) {
            ClassLoader commonLoader = null;
            for (Class<?> intf : interfaces) {
                ClassLoader intfLoader = intf.getClassLoader();
                if (ClassUtil.isSameOrParentLoader(commonLoader, (ClassLoader)intfLoader)) {
                    commonLoader = intfLoader;
                    continue;
                }
                if (ClassUtil.isSameOrParentLoader((ClassLoader)intfLoader, (ClassLoader)commonLoader)) continue;
                throw DynamicProxySupport.incompatibleClassLoaders(loader, interfaces);
            }
            if (!ClassUtil.isSameOrParentLoader(commonLoader, (ClassLoader)loader)) {
                throw DynamicProxySupport.incompatibleClassLoaders(loader, interfaces);
            }
            boolean loaded = PredefinedClassesSupport.loadClassIfNotLoaded(commonLoader, null, clazz);
            if (!loaded && !ClassUtil.isSameOrParentLoader((ClassLoader)clazz.getClassLoader(), (ClassLoader)loader)) {
                throw DynamicProxySupport.incompatibleClassLoaders(loader, interfaces);
            }
        } else if (!ClassUtil.isSameOrParentLoader((ClassLoader)clazz.getClassLoader(), (ClassLoader)loader)) {
            throw DynamicProxySupport.incompatibleClassLoaders(loader, interfaces);
        }
        return clazz;
    }

    private static RuntimeException incompatibleClassLoaders(ClassLoader provided, Class<?>[] interfaces) {
        StringBuilder b = new StringBuilder("Interface(s) not visible to the provided class loader: ");
        DynamicProxySupport.describeLoaderChain(b, provided);
        for (Class<?> intf : interfaces) {
            b.append("; interface ").append(intf.getName()).append(" loaded by ");
            DynamicProxySupport.describeLoaderChain(b, intf.getClassLoader());
        }
        throw new IllegalArgumentException(b.toString());
    }

    private static void describeLoaderChain(StringBuilder b, ClassLoader loader) {
        ClassLoader l = loader;
        while (true) {
            if (l != loader) {
                b.append(", child of ");
            }
            b.append(l);
            if (l == null) break;
            l = l.getParent();
        }
    }

    @Override
    public boolean isProxyClass(Class<?> clazz) {
        return this.proxyCache.containsValue(clazz);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static Class<?> getJdkProxyClass(ClassLoader loader, Class<?> ... interfaces) {
        return Proxy.getProxyClass(loader, interfaces);
    }

    static final class ProxyCacheKey {
        private final Class<?>[] interfaces;

        private ProxyCacheKey(Class<?> ... interfaces) {
            this.interfaces = interfaces;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProxyCacheKey) {
                ProxyCacheKey that = (ProxyCacheKey)obj;
                return Arrays.equals(this.interfaces, that.interfaces);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.interfaces);
        }

        public String toString() {
            return Arrays.toString(this.interfaces);
        }
    }
}

