/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.hosted;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.hosted.code.NonBytecodeStaticMethod;
import com.oracle.svm.reflect.hosted.ReflectionGraphKit;
import java.lang.reflect.Constructor;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;

public class ReflectiveNewInstanceMethod
extends NonBytecodeStaticMethod {
    private final Constructor<?> constructor;

    public ReflectiveNewInstanceMethod(String name, ResolvedJavaMethod prototype, Constructor<?> constructor) {
        super(name, prototype.getDeclaringClass(), prototype.getSignature(), prototype.getConstantPool());
        this.constructor = constructor;
    }

    public StructuredGraph buildGraph(DebugContext ctx, ResolvedJavaMethod m, HostedProviders providers, GraphProvider.Purpose purpose) {
        ReflectionGraphKit graphKit = new ReflectionGraphKit(ctx, providers, m);
        ValueNode argumentArray = graphKit.loadLocal(0, JavaKind.Object);
        graphKit.getFrameState().clearLocals();
        ResolvedJavaMethod targetMethod = providers.getMetaAccess().lookupJavaMethod(this.constructor);
        graphKit.emitEnsureInitializedCall(targetMethod.getDeclaringClass());
        Class<?>[] argTypes = this.constructor.getParameterTypes();
        ValueNode[] args = new ValueNode[argTypes.length + 1];
        args[0] = graphKit.append(this.createNewInstanceNode(targetMethod.getDeclaringClass()));
        graphKit.fillArgsArray(argumentArray, 1, args, argTypes);
        InvokeWithExceptionNode invoke = graphKit.createJavaCallWithException(CallTargetNode.InvokeKind.Special, targetMethod, args);
        graphKit.exceptionPart();
        graphKit.branchToInvocationTargetException(graphKit.exceptionObject());
        graphKit.endInvokeWithException();
        graphKit.createReturn(args[0], JavaKind.Object);
        graphKit.emitIllegalArgumentException(this.constructor, null, argumentArray);
        graphKit.emitInvocationTargetException();
        this.processInvoke(graphKit, invoke);
        return graphKit.finalizeGraph();
    }

    protected ValueNode createNewInstanceNode(ResolvedJavaType type) {
        return new NewInstanceNode(type, true);
    }

    protected void processInvoke(ReflectionGraphKit graphKit, InvokeWithExceptionNode invoke) {
    }
}

