/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.analysis;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatures;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.MethodTypeFlowBuilder;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.meta.SubstrateReplacements;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.hosted.HostedConfiguration;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.analysis.CallChecker;
import com.oracle.svm.hosted.analysis.DynamicHubInitializer;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.analysis.PointsToUnknownFieldHandler;
import com.oracle.svm.hosted.analysis.SubstrateUnsupportedFeatures;
import com.oracle.svm.hosted.analysis.UnknownFieldHandler;
import com.oracle.svm.hosted.analysis.UserLimitationsChecker;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import java.util.concurrent.ForkJoinPool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.options.OptionValues;

public class NativeImagePointsToAnalysis
extends PointsToAnalysis
implements Inflation {
    private final AnnotationSubstitutionProcessor annotationSubstitutionProcessor;
    private final DynamicHubInitializer dynamicHubInitializer;
    private final UnknownFieldHandler unknownFieldHandler;
    private final CallChecker callChecker;

    public NativeImagePointsToAnalysis(OptionValues options, AnalysisUniverse universe, HostedProviders providers, AnnotationSubstitutionProcessor annotationSubstitutionProcessor, ForkJoinPool executor, Runnable heartbeatCallback, UnsupportedFeatures unsupportedFeatures) {
        super(options, universe, providers, universe.hostVM(), executor, heartbeatCallback, (UnsupportedFeatures)new SubstrateUnsupportedFeatures(), SubstrateOptions.parseOnce());
        this.annotationSubstitutionProcessor = annotationSubstitutionProcessor;
        this.dynamicHubInitializer = new DynamicHubInitializer(universe, this.metaAccess, unsupportedFeatures, providers.getConstantReflection());
        this.unknownFieldHandler = new PointsToUnknownFieldHandler(this.metaAccess);
        this.callChecker = new CallChecker();
    }

    public boolean isCallAllowed(PointsToAnalysis bb, AnalysisMethod caller, AnalysisMethod target, NodeSourcePosition srcPosition) {
        return this.callChecker.isCallAllowed((BigBang)bb, caller, target, srcPosition);
    }

    public MethodTypeFlowBuilder createMethodTypeFlowBuilder(PointsToAnalysis bb, MethodTypeFlow methodFlow) {
        return HostedConfiguration.instance().createMethodTypeFlowBuilder(bb, methodFlow);
    }

    protected void checkObjectGraph(ObjectScanner objectScanner) {
        this.universe.getFields().forEach(field -> this.unknownFieldHandler.handleUnknownValueField(this, (AnalysisField)field));
        this.universe.getTypes().stream().filter(AnalysisType::isReachable).forEach(this.dynamicHubInitializer::initializeMetaData);
        this.universe.getTypes().stream().filter(AnalysisType::isReachable).forEach(type -> this.scanHub(objectScanner, (AnalysisType)type));
    }

    @Override
    public SVMHost getHostVM() {
        return (SVMHost)this.hostVM;
    }

    public void cleanupAfterAnalysis() {
        super.cleanupAfterAnalysis();
        this.unknownFieldHandler.cleanupAfterAnalysis();
    }

    public void checkUserLimitations() {
        super.checkUserLimitations();
        UserLimitationsChecker.check(this);
    }

    @Override
    public AnnotationSubstitutionProcessor getAnnotationSubstitutionProcessor() {
        return this.annotationSubstitutionProcessor;
    }

    private void scanHub(ObjectScanner objectScanner, AnalysisType type) {
        SVMHost svmHost = (SVMHost)this.hostVM;
        JavaConstant hubConstant = SubstrateObjectConstant.forObject(svmHost.dynamicHub((ResolvedJavaType)type));
        objectScanner.scanConstant(hubConstant, (ObjectScanner.ScanReason)ObjectScanner.ScanReason.HUB);
    }

    public static ResolvedJavaType toWrappedType(ResolvedJavaType type) {
        if (type instanceof AnalysisType) {
            return ((AnalysisType)type).getWrappedWithoutResolve();
        }
        if (type instanceof HostedType) {
            return ((HostedType)type).getWrapped().getWrappedWithoutResolve();
        }
        return type;
    }

    public boolean trackConcreteAnalysisObjects(AnalysisType type) {
        return !SVMHost.isUnknownClass((ResolvedJavaType)type);
    }

    @Override
    public SubstrateReplacements getReplacements() {
        return (SubstrateReplacements)super.getReplacements();
    }
}

