/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.analysis;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import java.util.regex.Pattern;
import org.graalvm.compiler.core.common.SuppressSVMWarnings;
import org.graalvm.compiler.graph.NodeSourcePosition;

public class CallChecker {
    private final Pattern illegalCalleesPattern;
    private final Pattern targetCallersPattern;

    public CallChecker() {
        String[] targetCallers = new String[]{"com\\.oracle\\.graal\\.", "org\\.graalvm[^\\.polyglot\\.nativeapi]"};
        this.targetCallersPattern = CallChecker.buildPrefixMatchPattern(targetCallers);
        String[] illegalCallees = new String[]{"java\\.util\\.stream", "java\\.util\\.Collection\\.stream", "java\\.util\\.Arrays\\.stream"};
        this.illegalCalleesPattern = CallChecker.buildPrefixMatchPattern(illegalCallees);
    }

    private static Pattern buildPrefixMatchPattern(String[] targetPrefixes) {
        StringBuilder patternStr = new StringBuilder("^(");
        for (int i = 0; i < targetPrefixes.length; ++i) {
            String prefix = targetPrefixes[i];
            patternStr.append(prefix);
            patternStr.append("(.*)");
            if (i >= targetPrefixes.length - 1) continue;
            patternStr.append("|");
        }
        patternStr.append(')');
        return Pattern.compile(patternStr.toString());
    }

    public boolean isCallAllowed(BigBang bb, AnalysisMethod caller, AnalysisMethod callee, NodeSourcePosition srcPosition) {
        String callerName;
        String calleeName = callee.getQualifiedName();
        if (this.illegalCalleesPattern.matcher(calleeName).find() && this.targetCallersPattern.matcher(callerName = caller.getQualifiedName()).find()) {
            SuppressSVMWarnings suppress = (SuppressSVMWarnings)caller.getAnnotation(SuppressSVMWarnings.class);
            for (AnalysisType callerType = caller.getDeclaringClass(); suppress == null && callerType != null; callerType = callerType.getEnclosingType()) {
                suppress = (SuppressSVMWarnings)callerType.getAnnotation(SuppressSVMWarnings.class);
            }
            if (suppress != null) {
                String[] reasons;
                for (String r : reasons = suppress.value()) {
                    if (!r.equals("AllowUseOfStreamAPI")) continue;
                    return true;
                }
            }
            String message = "Illegal: Graal/Truffle use of Stream API: " + calleeName;
            int bci = srcPosition.getBCI();
            String trace = caller.asStackTraceElement(bci).toString();
            bb.getUnsupportedFeatures().addMessage(callerName, caller, message, trace);
            return false;
        }
        return true;
    }
}

