/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.os;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.os.AbstractCommittedMemoryProvider;
import com.oracle.svm.core.os.ImageHeapProvider;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class OSCommittedMemoryProvider
extends AbstractCommittedMemoryProvider {
    private final VirtualMemoryTracker tracker = new VirtualMemoryTracker();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public OSCommittedMemoryProvider() {
    }

    @Override
    @Uninterruptible(reason="Still being initialized.")
    public int initialize(WordPointer isolatePointer, CEntryPointCreateIsolateParameters parameters) {
        if (!SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            int result = OSCommittedMemoryProvider.protectSingleIsolateImageHeap();
            if (result == 0) {
                isolatePointer.write((WordBase)CEntryPointSetup.SINGLE_ISOLATE_SENTINEL);
            }
            return result;
        }
        return ImageHeapProvider.get().initialize((Pointer)WordFactory.nullPointer(), (UnsignedWord)WordFactory.zero(), isolatePointer, (WordPointer)WordFactory.nullPointer());
    }

    @Override
    @Uninterruptible(reason="Tear-down in progress.")
    public int tearDown() {
        if (!SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            return 0;
        }
        PointerBase heapBase = Isolates.getHeapBase(CurrentIsolate.getIsolate());
        return ImageHeapProvider.get().freeImageHeap(heapBase);
    }

    @Override
    public Pointer allocate(UnsignedWord size, UnsignedWord alignment, boolean executable) {
        int access = 3;
        if (executable) {
            access |= 4;
        }
        Pointer reserved = (Pointer)WordFactory.nullPointer();
        if (!UnsignedUtils.isAMultiple(this.getGranularity(), alignment) && (reserved = VirtualMemoryProvider.get().reserve(size, alignment)).isNull()) {
            return (Pointer)WordFactory.nullPointer();
        }
        Pointer committed = VirtualMemoryProvider.get().commit((PointerBase)reserved, size, access);
        if (committed.isNull()) {
            if (reserved.isNonNull()) {
                VirtualMemoryProvider.get().free((PointerBase)reserved, size);
            }
            return (Pointer)WordFactory.nullPointer();
        }
        assert (reserved.isNull() || reserved.equal((UnsignedWord)committed));
        this.tracker.track(size);
        return committed;
    }

    @Override
    public boolean areUnalignedChunksZeroed() {
        return false;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean free(PointerBase start, UnsignedWord nbytes, UnsignedWord alignment, boolean executable) {
        if (VirtualMemoryProvider.get().free(start, nbytes) == 0) {
            this.tracker.untrack(nbytes);
            return true;
        }
        return false;
    }

    protected static class VirtualMemoryTracker {
        private UnsignedWord totalAllocated = (UnsignedWord)WordFactory.zero();

        protected VirtualMemoryTracker() {
        }

        public void track(UnsignedWord size) {
            this.totalAllocated = this.totalAllocated.add(size);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void untrack(UnsignedWord size) {
            this.totalAllocated = this.totalAllocated.subtract(size);
        }
    }
}

