/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.log;

import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.log.RealLog;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.UnsignedWord;

public class StringBuilderLog
extends RealLog {
    private final StringBuilder stringBuilder = new StringBuilder();

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, reason="This implementation allocates.")
    @Uninterruptible(reason="Called from uninterruptible code.", calleeMustBe=false)
    protected Log rawBytes(CCharPointer bytes, UnsignedWord length) {
        int i = 0;
        while (length.aboveThan(i)) {
            char currentChar = (char)bytes.read(i);
            this.stringBuilder.append(currentChar);
            ++i;
        }
        return this;
    }

    @Override
    public Log flush() {
        return this;
    }

    public String getResult() {
        return this.stringBuilder.toString();
    }
}

