/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.log;

import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.log.LogHandlerExtension;
import com.oracle.svm.core.log.RealLog;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.UnsignedWord;

public class FunctionPointerLogHandler
implements LogHandlerExtension {
    private final LogHandler delegate;
    private LogFunctionPointer logFunctionPointer;
    private LogFunctionPointer fatalLogFunctionPointer;
    private VoidFunctionPointer flushFunctionPointer;
    private VoidFunctionPointer fatalErrorFunctionPointer;
    private final FatalLog fatalLog = new FatalLog();

    public FunctionPointerLogHandler(LogHandler delegate) {
        this.delegate = delegate;
    }

    public void log(CCharPointer bytes, UnsignedWord length) {
        if (this.logFunctionPointer.isNonNull()) {
            this.logFunctionPointer.invoke(bytes, length);
        } else if (this.delegate != null) {
            this.delegate.log(bytes, length);
        }
    }

    public void flush() {
        if (this.flushFunctionPointer.isNonNull()) {
            this.flushFunctionPointer.invoke();
        } else if (this.delegate != null) {
            this.delegate.flush();
        }
    }

    @Override
    public Log enterFatalContext(CodePointer callerIP, String msg, Throwable ex) {
        if (this.delegate instanceof LogHandlerExtension) {
            return ((LogHandlerExtension)this.delegate).enterFatalContext(callerIP, msg, ex);
        }
        return this.fatalLog;
    }

    public void fatalError() {
        if (this.fatalErrorFunctionPointer.isNonNull()) {
            this.fatalErrorFunctionPointer.invoke();
        } else if (this.delegate != null) {
            this.delegate.fatalError();
        }
    }

    public CFunctionPointer getFatalErrorFunctionPointer() {
        return this.fatalErrorFunctionPointer;
    }

    public static boolean parseVMOption(String optionString, WordPointer extraInfo) {
        if (optionString.equals("_log")) {
            FunctionPointerLogHandler.handler((String)optionString).logFunctionPointer = (LogFunctionPointer)extraInfo;
            return true;
        }
        if (optionString.equals("_fatal_log")) {
            FunctionPointerLogHandler.handler((String)optionString).fatalLogFunctionPointer = (LogFunctionPointer)extraInfo;
            return true;
        }
        if (optionString.equals("_flush_log")) {
            FunctionPointerLogHandler.handler((String)optionString).flushFunctionPointer = (VoidFunctionPointer)extraInfo;
            return true;
        }
        if (optionString.equals("_fatal")) {
            FunctionPointerLogHandler.handler((String)optionString).fatalErrorFunctionPointer = (VoidFunctionPointer)extraInfo;
            return true;
        }
        return false;
    }

    private static FunctionPointerLogHandler handler(String optionString) {
        LogHandler handler = (LogHandler)ImageSingletons.lookup(LogHandler.class);
        if (handler == null || !(handler instanceof FunctionPointerLogHandler)) {
            throw new IllegalArgumentException("The " + optionString + " option is not supported by JNI_CreateJavaVM");
        }
        return (FunctionPointerLogHandler)handler;
    }

    public static void afterParsingVMOptions() {
        LogHandler handler = (LogHandler)ImageSingletons.lookup(LogHandler.class);
        if (handler == null || !(handler instanceof FunctionPointerLogHandler)) {
            return;
        }
        FunctionPointerLogHandler fpHandler = (FunctionPointerLogHandler)handler;
        if (fpHandler.logFunctionPointer.isNonNull()) {
            if (fpHandler.flushFunctionPointer.isNull()) {
                throw new IllegalArgumentException("The _flush_log option cannot be null when _log is non-null");
            }
        } else if (fpHandler.flushFunctionPointer.isNonNull()) {
            throw new IllegalArgumentException("The _log option cannot be null when _flush_log is non-null");
        }
    }

    static interface FatalContextFunctionPointer
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public boolean invoke(CodePointer var1, String var2, Throwable var3);
    }

    static interface VoidFunctionPointer
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void invoke();
    }

    static interface LogFunctionPointer
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void invoke(CCharPointer var1, UnsignedWord var2);
    }

    class FatalLog
    extends RealLog {
        FatalLog() {
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
        protected Log rawBytes(CCharPointer bytes, UnsignedWord length) {
            if (FunctionPointerLogHandler.this.fatalLogFunctionPointer.isNonNull()) {
                FunctionPointerLogHandler.this.fatalLogFunctionPointer.invoke(bytes, length);
            } else {
                FunctionPointerLogHandler.this.log(bytes, length);
            }
            return this;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when logging.")
        public Log flush() {
            if (FunctionPointerLogHandler.this.fatalLogFunctionPointer.isNull()) {
                FunctionPointerLogHandler.this.flush();
            }
            return this;
        }
    }
}

